//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  \short A class which provides notifications of state changes to a SmartCursor via QObject signals.
    ///  \ingroup kte_group_smart_classes
    ///  This class provides notifications of changes to a SmartCursor such as the
    ///  position in the document, and deletion or insertion of text immediately
    ///  before or after the cursor.
    ///  If you prefer to receive notifications via inheritance, see SmartCursorWatcher.
    ///  \sa SmartCursor, SmartCursorNotifier
    ///  \author Hamish Rodda \<rodda@kde.org\>
    ///   See <see cref="ISmartCursorNotifierSignals"></see> for signals emitted by SmartCursorNotifier
    /// </remarks>        <short>    \short A class which provides notifications of state changes to a SmartCursor via QObject signals.</short>
    [SmokeClass("KTextEditor::SmartCursorNotifier")]
    public class SmartCursorNotifier : QObject, IDisposable {
        protected SmartCursorNotifier(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(SmartCursorNotifier), this);
        }
        /// <remarks>
        ///  Default constructor.
        ///      </remarks>        <short>    Default constructor.</short>
        public SmartCursorNotifier() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("SmartCursorNotifier", "SmartCursorNotifier()", typeof(void));
        }
        /// <remarks>
        ///  Returns whether this notifier will notify of changes that happen
        ///  directly to the cursor, e.g. by calls to SmartCursor.SetPosition(), rather
        ///  than just when surrounding text changes.
        ///      </remarks>        <short>    Returns whether this notifier will notify of changes that happen  directly to the cursor, e.</short>
        public bool WantsDirectChanges() {
            return (bool) interceptor.Invoke("wantsDirectChanges", "wantsDirectChanges() const", typeof(bool));
        }
        /// <remarks>
        ///  Set whether this notifier should notify of changes that happen
        ///  directly to the cursor, e.g. by calls to SmartCursor.SetPosition(), rather
        ///  than just when surrounding text changes.
        ///  \param wantsDirectChanges whether this notifier should provide notifications for direct changes.
        ///      </remarks>        <short>    Set whether this notifier should notify of changes that happen  directly to the cursor, e.</short>
        public void SetWantsDirectChanges(bool wantsDirectChanges) {
            interceptor.Invoke("setWantsDirectChanges$", "setWantsDirectChanges(bool)", typeof(void), typeof(bool), wantsDirectChanges);
        }
        ~SmartCursorNotifier() {
            interceptor.Invoke("~SmartCursorNotifier", "~SmartCursorNotifier()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~SmartCursorNotifier", "~SmartCursorNotifier()", typeof(void));
        }
        protected new ISmartCursorNotifierSignals Emit {
            get { return (ISmartCursorNotifierSignals) Q_EMIT; }
        }
    }

    public interface ISmartCursorNotifierSignals : IQObjectSignals {
        /// <remarks>
        ///  The cursor's position was changed.
        ///  \param cursor pointer to the cursor which generated the notification.
        ///      </remarks>        <short>    The cursor's position was changed.</short>
        [Q_SIGNAL("void positionChanged(KTextEditor::SmartCursor*)")]
        void PositionChanged(KTextEditor.SmartCursor cursor);
        /// <remarks>
        ///  The cursor's surrounding characters were both deleted simultaneously.
        ///  The cursor is automatically placed at the start of the deleted region.
        ///  \param cursor pointer to the cursor which generated the notification.
        ///      </remarks>        <short>    The cursor's surrounding characters were both deleted simultaneously.</short>
        [Q_SIGNAL("void positionDeleted(KTextEditor::SmartCursor*)")]
        void PositionDeleted(KTextEditor.SmartCursor cursor);
        /// <remarks>
        ///  One character immediately surrounding the cursor was deleted.
        ///  If both characters are simultaneously deleted, positionDeleted() is called instead.
        ///  \param cursor pointer to the cursor which generated the notification.
        ///  \param deletedBefore <code>true</code> if the character immediately before was deleted,
        ///                       <code>false</code> if the character immediately after was deleted.
        ///      </remarks>        <short>    One character immediately surrounding the cursor was deleted.</short>
        [Q_SIGNAL("void characterDeleted(KTextEditor::SmartCursor*, bool)")]
        void CharacterDeleted(KTextEditor.SmartCursor cursor, bool deletedBefore);
        /// <remarks>
        ///  A character was inserted immediately before or after the cursor, as given
        ///  by <pre>insertedBefore</pre>.
        ///  \param cursor pointer to the cursor which generated the notification.
        ///  \param insertedBefore \e true if a character was inserted before <pre>cursor</pre>,
        ///                        \e false if a character was inserted after
        ///      </remarks>        <short>    A character was inserted immediately before or after the cursor, as given  by \p insertedBefore.</short>
        [Q_SIGNAL("void characterInserted(KTextEditor::SmartCursor*, bool)")]
        void CharacterInserted(KTextEditor.SmartCursor cursor, bool insertedBefore);
        /// <remarks>
        ///  The SmartCursor instance specified by <pre>cursor</pre> is being deleted.
        ///  \param cursor pointer to the cursor which is about to be deleted.  It is
        ///                still safe to access information at this point.
        ///      </remarks>        <short>    The SmartCursor instance specified by \p cursor is being deleted.</short>
        [Q_SIGNAL("void deleted(KTextEditor::SmartCursor*)")]
        void Deleted(KTextEditor.SmartCursor cursor);
    }
}
