/***************************************************************************
 *   Copyright (C) 2015 by Eike Hein <hein@kde.org>                        *
 *   Copyright (C) 2019 by Mark Nauwelaerts <mark.nauwelaerts@gmail.com>   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#ifndef LSPCLIENTCONFIGPAGE_H
#define LSPCLIENTCONFIGPAGE_H

#include <KTextEditor/ConfigPage>

class LSPClientPlugin;

class QCheckBox;
class QLineEdit;

class KUrlRequester;

class LSPClientConfigPage : public KTextEditor::ConfigPage
{
    Q_OBJECT

    public:
        explicit LSPClientConfigPage(QWidget *parent = nullptr, LSPClientPlugin *plugin = nullptr);
        ~LSPClientConfigPage() override {};

        QString name() const override;
        QString fullName() const override;
        QIcon icon() const override;

    public Q_SLOTS:
        void apply() override;
        void defaults() override;
        void reset() override;

    private:
        QCheckBox* m_symbolDetails;
        QCheckBox* m_symbolExpand;
        QCheckBox* m_symbolTree;
        QCheckBox* m_symbolSort;
        QCheckBox* m_complDoc;
        QCheckBox* m_refDeclaration;
        QCheckBox* m_diagnostics;
        QCheckBox* m_diagnosticsHighlight;
        QCheckBox* m_diagnosticsMark;
        KUrlRequester *m_configPath;

        LSPClientPlugin *m_plugin;
};

#endif
