#include <stdio.h>
#include <qapp.h>
#include <qdialog.h>
#include <qfiledlg.h>
#include <qlabel.h>
#include <qlined.h>
#include <qcombo.h>
#include <qmsgbox.h>
#include <kapp.h>
#include <kprocess.h>
#include <kdebug.h>
#include <kseparator.h>

#include <sys/types.h>
#include <dirent.h>
#include <unistd.h>
#include "KPKman.moc"

void KPK::listdblclk(const char *fname)
{
	char tmp[1024];
	strcpy(tmp,fname);
}

void KPK::showpress()
{
	char filename[1024];
	char buf[90];
	FILE *f;
	int i;
	
	if (packages->currentItem()==-1) {
		QMessageBox::information(this,"KPKGman","Select a voice in\nInstalled Packages","OK",0);
		return;
	}
	sprintf(filename,"/var/adm/packages/%s",packages->text(packages->currentItem()));
	results->clear();
	f=fopen(filename,"r");
	if (f!=NULL) {
		do {
			fgets(buf,90,f);
			if (!feof(f)) {
				results->insertItem(buf);
			}
		} while (!feof(f));
	}
	fclose(f);
}

void KPK::exitpress()
{
	exit(0);
}

void KPK::recinput(KProcess *proc, char *buffer, int buflen)
{
	int i;
	for (i=0;i<buflen;i++)
		if (buffer[i]=='\n') buffer[i]=' ';
	buffer[i]=0;
	Lstatus->setText(buffer);
}

void KPK::processexited(KProcess *proc)
{
	load_pkg();
	Lstatus->setText("KPKGman v0.2");
	delete proc;
}

void KPK::removepress()
{
	char tmp[1024],pkg[1024];
	QLabel *inf;
	KProcess *proc;

	strcpy(pkg,packages->text(packages->currentItem()));
	if (packages->currentItem()==-1) {
		QMessageBox::information(this,"KPKGman","Select a voice in\nInstalled Packages","OK",0);
		return;
	}
	sprintf(tmp,"Package <%s>\nmay contain files used by other packages.\n  Continue ?",pkg);
	switch (QMessageBox::warning(this,"KPKGman",tmp,
	"&Yes","&NO",0,0,1)) {
	case 1: return;
	}
	
	chdir(path);
	proc=new KProcess();
	(*proc) << "/sbin/removepkg"<<pkg;
	connect(proc,SIGNAL(receivedStderr(KProcess *,char *,int)),this,SLOT(recinput(KProcess *,char *,int)));
	connect(proc,SIGNAL(receivedStdout(KProcess *,char *,int)),this,SLOT(recinput(KProcess *,char *,int)));
	connect(proc,SIGNAL(processExited(KProcess *)),this,SLOT(processexited(KProcess *)));
	proc->start(KProcess::NotifyOnExit,KProcess::AllOutput);
}

void KPK::installpress()
{
	KProcess *proc;

	char filename[1024],tmp[1024];
	memset(filename,0,1024);
	strcpy(filename,QFileDialog::getOpenFileName(0,"*.tgz",this));
	if (strlen(filename)==0) return;
	sprintf(tmp,"Package\n<%s>\nmay overwrite other packages.\n  Continue ?",filename);
	switch (QMessageBox::warning(this,"KPKGman",tmp,"&Yes","&NO",0,0,1)) {
	case 1: return;
	}
	proc=new KProcess();
	(*proc) << "/sbin/installpkg"<<filename;
	connect(proc,SIGNAL(receivedStderr(KProcess *,char *,int)),this,SLOT(recinput(KProcess *,char *,int)));
	connect(proc,SIGNAL(receivedStdout(KProcess *,char *,int)),this,SLOT(recinput(KProcess *,char *,int)));
	connect(proc,SIGNAL(processExited(KProcess *)),this,SLOT(processexited(KProcess *)));
	proc->start(KProcess::NotifyOnExit,KProcess::AllOutput);
}

void KPK::load_pkg()
{
	DIR * dir;
	struct dirent *dirent;

	packages->clear();
	dir=opendir(path);
	if (dir!=NULL) {
		do {
			dirent=readdir(dir);
			if (dirent!=NULL && strcmp(dirent->d_name,".")!=0 && strcmp(dirent->d_name,"..")!=0) {
				packages->inSort(dirent->d_name);
			}
		} while (dirent!=NULL);
	}
	closedir(dir);
}

KPK::KPK( QWidget *parent, const char *name, char *p) 
	: QDialog(parent, name)
{

	QLabel *l1=new QLabel(this), *l2=new QLabel(this);

	resize(700,370);
	setMinimumSize(700,370);
	setMaximumSize(700,370);
	
	l1->setText("Installed Packages");
	l1->move(0,0);
	l1->resize(150,30);
	l2->setText("Package Details");
	l2->move(270,0);
	l2->resize(150,30);

	strcpy(path,p);
	packages=new QListBox(this,"packages");
	packages->resize(150,320);
	packages->move(0,25);

	load_pkg();

	Bshow = new QPushButton(this,"show");
	Bshow->setText("Show Info");
	Bshow->move(160,50);
	Bshow->resize(100,30);
	connect(Bshow,SIGNAL(clicked()),SLOT(showpress()));

	Bremove = new QPushButton(this,"remove");
	Bremove->setText("Remove PKG");
	Bremove->resize(100,30);
	Bremove->move(160,90);
	connect(Bremove,SIGNAL(clicked()),SLOT(removepress()));

	Binstall = new QPushButton(this,"install");
	Binstall->setText("Install PKG");
	Binstall->resize(100,30);
	Binstall->move(160,130);
	connect(Binstall,SIGNAL(clicked()),SLOT(installpress()));

	Bexit = new QPushButton(this,"Exit");
	Bexit->setText("Close");
	Bexit->resize(100,30);
	Bexit->move(160,170);
	connect(Bexit,SIGNAL(clicked()),SLOT(exitpress()));

	results=new QListBox(this,"results");
	results->resize(430,320);
	results->move(270,25);
	connect(results,SIGNAL(highlighted(int)),results,SLOT(clearSelection()));

	Lstatus = new QPushButton(this);
	Lstatus->setText("KPKGman v0.1");
	Lstatus->resize(700,20);
	Lstatus->move(0,350);

	l1= new QLabel(this);
	l1->move(160,210);
	l1->resize(100,100);
	l1->setPixmap(QPixmap("kpkgman.gif"));
}

main(int argc, char **argv)
{
	KApplication kt( argc, argv);
	KPK *w;
	
	if (argc==1) 
		w=new KPK(NULL,"KPKGmanager","/var/adm/packages");
	else
		w=new KPK(NULL,"KPKGmanager",argv[1]);
	
	kt.setMainWidget(w);
	w->show();
	return kt.exec();
}