/***************************************************************************
                          kinstall.cpp  -  KInstall's Main Window
                             -------------------                                         
    begin                : Sat Apr 10 01:24:55 WEST 1999
                                           
    copyright            : (C) 1999 by Hugo Santos                         
    email                : hugo_santos@bigfoot.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "kinstall.h"

/* Some of the ideas of _KInstall are from
		KWizard*/

_KInstall::_KInstall(){
	_OkButton=0;
	_CancelButton=0;
	_HelpButton=0;
	_NextButton=0;
	_BackButton=0;
	_title=0;
	_image=0;
	_page=0;
	inst.wheretoinstall=0;
	inst.xtrargs=0;
}
_KInstall::~_KInstall(){
}

void _KInstall::setPage( _Page *page ){
	_page = page;
	reArrange();
}

QPushButton *_KInstall::getButtonOk(){
	return _OkButton;
}

QPushButton *_KInstall::getButtonCancel(){
	return _CancelButton;
}

QPushButton *_KInstall::getButtonHelp(){
	return _HelpButton;
}

QPushButton *_KInstall::getButtonNext(){
	return _NextButton;
}

QPushButton *_KInstall::getButtonBack(){
	return _BackButton;
}

QLabel *_KInstall::getLabelTitle(){
	return _title;
}

QLabel *_KInstall::getLabelImage(){
	return _image;
}

void _KInstall::setButtonOk( const char *name ){
	if (!_OkButton){
		_OkButton = new QPushButton(name,this);
		_OkButton->show();
		connect(_OkButton,SIGNAL(clicked()),SLOT(slotOkClicked()));
	}
	else
		_OkButton->setText(name);
	reArrange();
}

void _KInstall::setButtonCancel( const char *name ){
	if (!_CancelButton){
		_CancelButton = new QPushButton(name,this);
		_CancelButton->show();
		connect(_CancelButton,SIGNAL(clicked()),SLOT(slotCancelClicked()));
	}
	else
		_CancelButton->setText(name);
	reArrange();
}

void _KInstall::setButtonHelp( const char *name ){
	if (!_HelpButton){
		_HelpButton = new QPushButton(name,this);
		_HelpButton->show();
		connect(_HelpButton,SIGNAL(clicked()),SLOT(slotHelpClicked()));
	}
	else
		_HelpButton->setText(name);
	reArrange();
}

void _KInstall::setButtonNext( const char *name ){
	if (!_NextButton){
		_NextButton = new QPushButton(name,this);
		_NextButton->show();
		connect(_NextButton,SIGNAL(clicked()),SLOT(slotNextClicked()));
	}
	else
		_NextButton->setText(name);
	reArrange();
}

void _KInstall::setButtonBack( const char *name ){
	if (!_BackButton){
		_BackButton = new QPushButton(name,this);
		_BackButton->show();
		connect(_BackButton,SIGNAL(clicked()),SLOT(slotBackClicked()));
	}
	else
		_BackButton->setText(name);
	reArrange();
}

void _KInstall::setButtonOkEnabled( bool tf ){
	if (_OkButton)
		_OkButton->setEnabled( tf );
}

void _KInstall::setButtonCancelEnabled( bool tf ){
	if (_CancelButton)
		_CancelButton->setEnabled( tf );
}

void _KInstall::setButtonHelpEnabled( bool tf ){
	if (_HelpButton)
		_HelpButton->setEnabled( tf );
}

void _KInstall::setButtonNextEnabled( bool tf ){
	if (_NextButton)
		_NextButton->setEnabled( tf );
}

void _KInstall::setButtonBackEnabled( bool tf ){
	if (_BackButton)
		_BackButton->setEnabled( tf );
}

void _KInstall::setTitleFont( const char *family, int pointSize, int weight, bool italic ){
	if (_title)
		_title->setFont( QFont(family,pointSize,weight,italic) );
}

void _KInstall::setTitle( const char *title ){
	if (!_title){
		_title = new QLabel(title,this);
		_title->show();
	}
	else
		_title->setText( title );
	QString t;t.sprintf("KInstall: %s",title);
	setCaption(t);
	reArrange();
}

void _KInstall::setImage( QPixmap i ){
	if (!_image){
		_image = new QLabel(this);
		//_image->setFrameStyle( QFrame::WinPanel | QFrame::Sunken );
		_image->setPixmap( i );
	}
	else
		_image->setPixmap( i );
	reArrange();
}

void _KInstall::resizeEvent( QResizeEvent *e ){
	reArrange();
}

void _KInstall::reArrange(){
	if (_image!=0)
		_image->setGeometry(5,5,120,260);
	if (_title!=0)
		if (_image!=0)
			_title->setGeometry(130,5,width()-140,40);
		else
			_title->setGeometry(5,5,width()-10,40);
	if (_page!=0)
		if (_image!=0)
			if (_title!=0)
				if (_OkButton!=0||_CancelButton!=0||_HelpButton!=0||_BackButton!=0||_NextButton!=0)
					_page->setGeometry(130,50,width()-135,height()-90);
				else
					_page->setGeometry(130,50,width()-135,height()-50);
			else
				if (_OkButton!=0||_CancelButton!=0||_HelpButton!=0||_BackButton!=0||_NextButton!=0)
					_page->setGeometry(130,5,width()-135,height()-40);
				else
					_page->setGeometry(130,5,width()-135,height()-10);
		else
			if (_title!=0)
				if (_OkButton!=0||_CancelButton!=0||_HelpButton!=0||_BackButton!=0||_NextButton!=0)
					_page->setGeometry(5,50,width()-10,height()-90);
				else
					_page->setGeometry(5,50,width()-10,height()-50);
			else
				if (_OkButton!=0||_CancelButton!=0||_HelpButton!=0||_BackButton!=0||_NextButton!=0)
					_page->setGeometry(5,5,width()-10,height()-40);
				else
					_page->setGeometry(5,5,width()-10,height()-10);
	if (_OkButton!=0)
		if (_CancelButton!=0)
			if (_HelpButton!=0)
				_OkButton->setGeometry(155,height()-35,70,30);
			else
				_OkButton->setGeometry(80,height()-35,70,30);
		else if (_HelpButton!=0)
			_OkButton->setGeometry(80,height()-35,70,30);
		else
			_OkButton->setGeometry(5,height()-35,70,30);
	if (_CancelButton!=0)
		_CancelButton->setGeometry(5,height()-35,70,30);
	if (_HelpButton!=0)
		if (_CancelButton!=0)
			_HelpButton->setGeometry(80,height()-35,70,30);
		else
			_HelpButton->setGeometry(5,height()-35,70,30);
	if (_BackButton!=0)
		_BackButton->setGeometry(width()-150,height()-35,70,30);
	if (_NextButton!=0)
		_NextButton->setGeometry(width()-75,height()-35,70,30);
}
			
void _KInstall::slotOkClicked(){
	emit okclicked();
}

void _KInstall::slotCancelClicked(){
	emit cancelclicked();
}

void _KInstall::slotHelpClicked(){
	emit helpclicked();
}

void _KInstall::slotNextClicked(){
	emit nextclicked();
}

void _KInstall::slotBackClicked(){
	emit backclicked();
}

void _KInstall::errorForceQuit(QString error_description){
	KMsgBox *mb;
	QString s_err(ERR_ERR);
	QString t;
	printf("\n\n" + s_err + " * " + s_err + " * " + s_err + "\n\n["+ MSG_17+":%s ]\n\nKInstall " + MSG_18 +"!\n\n",(const char *)error_description);
	t.sprintf("%s%s\n\n%s",MSG_19,(const char *)error_description,MSG_20);
	mb->message(this,"KInstall: " + s_err,t,2,BTN_OK);
	exit(0);
}

void _KInstall::slotClean(){
	KShellProcess p;
	QDir d("/tmp/ki_temp");
	p << "rm -rf /tmp/ki_temp";
	QString s1;
	s1.sprintf("KInstall: %s\n\n",MSG_02);
	printf(s1);
	p.start(KProcess::Block,KProcess::AllOutput);
	if (d.exists()){
		QString s2;
		s2.sprintf("KInstall: %s!\n\n",ERR_05);
		printf(s2);
		}
	else {
		QString s3;
		s3.sprintf("KInstall: %s!\n\n",MSG_03);
		printf(s3);
		}
}
	
bool _KInstall::slotDoesThisInstHaveADir(){
	QFile f("/tmp/ki_temp/configure");
	if (!f.exists())
		return true;
	else
		return false;
}

_Page::_Page(_KInstall *parent, const char *name ):QWidget(parent,name){
	ki = parent;
}
_Page::~_Page(){}








