#include <sys/types.h>
#include <signal.h>
#include <unistd.h>

#include <ktopwidget.h>
#include <kpanner.h>
#include <kmsgbox.h>
#include <time.h>        
#include <qlined.h>
#include <ktabctl.h>
#include <qregexp.h>

#include "bind.h"
#include "ksoaedit.h"
#include "secondary.h"
#include "newPrimary.h"

#include "bind.moc"

KBindWidget::KBindWidget()
  : KTopLevelWidget()
{
  resize(550,320);

  resize(550,320);
  KTabCtl *tb = new KTabCtl(this);
  tb->resize(500,300);
  QWidget *primary = new QWidget(tb);
  QWidget *second = new QWidget(tb);
  QWidget *misc = new QWidget(tb);
  QWidget *forward = new QWidget(tb); 
  QWidget *xfer = new QWidget(tb);
  QWidget *bogus = new QWidget(tb);
  QWidget *simplestats = new QWidget(tb);
  QWidget *detailstats = new QWidget(tb);

  directory = new QString();
  cache = new QString();
  primary->resize(300,280);
  second->resize(300,280);
  misc->resize(300,280);
  forward->resize(300,280);
  xfer->resize(300,280);
  bogus->resize(300,280);
  simplestats->resize(300,280);
  detailstats->resize(300,280);

  tb->addTab(primary,"Primary");
  tb->addTab(second,"Secondary");
  tb->addTab(misc,"Misc");
  tb->addTab(forward,"Forwarders");
  tb->addTab(xfer,"xfer nets");
  tb->addTab(bogus,"Bogus NS");
  tb->addTab(simplestats,"Simple Status");
  tb->addTab(detailstats,"Detailed Status");

  QPushButton *newp = new QPushButton("new Domain",primary, "new");
  newp->move(300,40);
  connect(newp,SIGNAL(clicked()),SLOT(pnewclicked()));

  delp = new QPushButton("delete Domain",primary, "delete");
  delp->move(300,80);
  connect(delp,SIGNAL(clicked()),SLOT(pdelclicked()));
  delp->setEnabled(false);
  

  pl1 = new QLabel("Primary Domains",primary);  
  pl1->setAutoResize(TRUE);
  pl1->move(20,20);

  sl1 = new QLabel("Secondary Domains",second);  
  sl1->setAutoResize(TRUE);
  sl1->move(20,20);

  slist = new QListBox(second,"secondary");
  slist->move(20,40);
  slist->resize(200,200);

  plist = new QListBox(primary,"primary");
  plist->move(20,40);
  plist->resize(200,200);

  QLabel *fl = new QLabel("Forwarders (Name servers to send unresolved querys to)",forward);
  fl->setAutoResize(TRUE);
  fl->move(20,20);
  
  flist = new QListBox(forward,"forwarders");
  flist->move(20,40);
  flist->resize(200,200);

  QLabel *xl = new QLabel("Restrict zone transfers from your name server to the following IP adresses or networks",xfer);
  xl->setAutoResize(TRUE);
  xl->move(20,20);
  xlist = new QListBox(xfer,"xfernets");
  xlist->move(20,40);
  xlist->resize(200,200);

  QLabel *bl = new QLabel("Don't query this Servers : (because they are known to give bad answers)", bogus);
  bl->setAutoResize(TRUE);
  bl->move(20,20);
  
  blist = new QListBox(bogus,"bogusns");
  blist->move(20,40);
  blist->resize(200,200);
 
  diredit = new QLineEdit(misc,"test");
  diredit->move(140,30);
  diredit->resize(200,30);

  ml1 = new QLabel("Data Path :",misc);
  ml1->move(20,35);
  ml1->setAutoResize(TRUE);

  cacheedit = new QLineEdit(misc,"misc");
  cacheedit->move(140,60);
  cacheedit->resize(200,30);

  ml2 = new QLabel("Cache Data file :",misc);
  ml2->move(20,65);
  ml2->setAutoResize(TRUE);

  // init the QList 
  primaryList = new (QList<primaryDomain>);
  secondaryList = new (QList<secondaryDomain>);
  primaryList->setAutoDelete(TRUE);
  secondaryList->setAutoDelete(TRUE);
  forwarders=new QStrList();
  xfrnets = new QStrList();
  bogusns = new QStrList();
  
  options=0;

  parseboot();
  displaySettings();

  connect(plist,SIGNAL(selected(const char *)),SLOT(primaryClick(const char *)) );
  connect(slist,SIGNAL(selected(const char *)),SLOT(secondaryClick(const char *)) );
  connect(plist,SIGNAL(highlighted(int)),SLOT(listsel(int)));
  

  QFile *file = new QFile("/var/run/named.pid");
  
  QLabel *tl = new QLabel(simplestats);
  tl->setGeometry(10,10,200,20);
  statlist=new KTabListBox(detailstats,"stats",25,0);
  statlist->move(20,50);
  statlist->resize(450,200); 
  statlist->clearTableFlags(Tbl_hScrollBar);
  statlist->setTableFlags(Tbl_autoHScrollBar);
  statlist->setTableFlags(Tbl_autoVScrollBar);
  statlist->setSeparator(' ');

  simplestatlist = new QListBox(simplestats);
  simplestatlist->move(20,40);
  simplestatlist->resize(200,200);

  
  if(file->open(IO_ReadOnly))
    {
	char tmp[255];
	int pid;
	file->readLine(tmp,255);
	file->close();
	printf("Removing old named.stats\n");
	file->setName("/var/tmp/named.stats");
	file->open(IO_Truncate | IO_WriteOnly);
	file->close();
	pid=atoi(tmp);
	printf("Sending SIGIOT to named (pid %u)\n",pid);
	kill(pid,SIGIOT);
	usleep(1000000);
	// sleep one second to allow named to dump its data 
	sprintf(tmp,"PID  of named : %u",pid);
	tl->setText(tmp);
	readStat();	       
  } else { tl->setText("PID of named not aviable !!!"); }    
}

bool KBindWidget::isIP(QString ip)
{
   int n=0;
   QRegExp r = QRegExp("*.*.*.*",TRUE,TRUE);
   n=ip.contains(r);
   return n==4;
}

void KBindWidget::pdelclicked()
{
    QString st;
    primaryDomain *pl,*d;
    int a;
    
    a=KMsgBox::yesNo(this,"Alert !","Do you really want to \ndelte this domain ?",8);  
    
    if (a == 1) {    
   	 st = plist->text(todel);
   	 plist->removeItem(todel);
   	 if (plist->currentItem() < 0)	
   	   delp->setEnabled(false);

	    for (pl=primaryList->first();pl!=0;pl=primaryList->next()) {
 	     if (strcmp(pl->domain,st) == 0) {
		d=pl;
		delete pl->data;
		primaryList->remove(d);
	      }
	    } 	
//	   if (d != 0)
//	     primaryList->remove(d);
	}
}

void KBindWidget::listsel(int a)
{
  todel=a;
  delp->setEnabled(true);
}

void KBindWidget::pnewclicked()
{
	newPrimary *np;
	np = new newPrimary(primaryList);
	np->show();
	displaySettings();
}

void KBindWidget::readStat()
{
	char tmp[255];
	QString st1;
	char tmp1[255];
	char *tok;
	bool s1,s2;
	int n;
	n=0;
	debug("Parsing Status file ...");
	QFile *file=new QFile("/var/tmp/named.stats");
	s1=false; s2=false;
	if (file->open(IO_ReadOnly)) {
		statlist->setColumn(n++,"IP",80);
		while (file->readLine(tmp,255) != 0) {
			//debug(tmp);
			if (strncmp(tmp,"+++",3) == 0) { s1=true; }
			if (strncmp(tmp,"++ ",3) == 0) { s2=true; }
			if (s1) {
				do {
					file->readLine(tmp,255);
					if (strncmp(tmp,"+",1) != 0)
						simplestatlist->insertItem(tmp);
				} while (strncmp(tmp,"++ ",3) != 0);
				do {
					file->readLine(tmp,255);
					// printf("S2 : %s\n",tmp);
					if (strncmp(tmp,"(Legend)",8) == 0) {
						file->readLine(tmp,255);
						do {
							tok=strtok(tmp," \t");
							do {
								statlist->setColumn(n++,tok,50);
								tok=strtok(0," \t");
							} while (strlen(tok) > 0);
							file->readLine(tmp,255);
						} while (strncmp(tmp,"(",1) != 0);
						
						file->readLine(tmp1,255);
						st1=tmp;
						st1.remove(0,1);
						st1.remove(st1.length()-2,2);		
						st1=st1+" "+tmp1;
						st1=st1.simplifyWhiteSpace();
						statlist->appendItem(st1);
					} else if (strncmp(tmp,"-",1) != 0) {
						// Parse the hosts ..
						file->readLine(tmp1,255);
						st1=tmp;
						st1.remove(0,1);
						st1.remove(st1.length()-2,2);		
						st1=st1+" "+tmp1;
						st1=st1.simplifyWhiteSpace();
						statlist->appendItem(st1);
					}											
				} while (strncmp(tmp,"--",2) !=0 );
				s1=false;
			} 
		}
	} else {
		printf("No Status information found !\n");
	}	
}

void KBindWidget::parseboot()
{
  char tmp[255];
  char *tok,*tok1;
  QString st,st1,st2;
  primaryDomain *pl;
  secondaryDomain *sl;
 
  QFile *file = new QFile("/etc/named.boot");
  if(!file->open(IO_ReadOnly))
    {
      return;
    }                                                      
  while (file->readLine(tmp,255) != 0) {
    tok = strtok(tmp," \t");
    if (strcmp(tok,"primary") == 0) {
      tok = strtok(0," \t");
      st.sprintf("%s",tok);
      tok = strtok(0," \t");
      st1.sprintf("%s",tok);
      pl = new primaryDomain(st.stripWhiteSpace(),st1.stripWhiteSpace());
      primaryList->append(pl);        
      readSOA(pl, *directory + '/'+ pl->file);
    }
    if (strcmp(tok,"secondary") == 0) {
      sl= new secondaryDomain();
      tok = strtok(0," \t");
      st=tok;
      sl->domain=st.stripWhiteSpace();
      sl->ip = new QStrList();
      tok = strtok(0," \t");
      tok1=tok;
      while (strlen(tok) > 0) {
     	tok1=tok;
      	tok = strtok(0," \t");
      	if (strlen(tok) > 0) {
      	  st=tok1;
      	  st=st.stripWhiteSpace();
      	  sl->ip->append(st);
      	}
      }
      st2.sprintf("%s",tok1);
      st2=st2.stripWhiteSpace();
      if  (isIP(tok1)) {sl->ip->append(st2); } else {sl->file=st2;} 

      secondaryList->append(sl);
    }
    if (strcmp(tok,"directory") == 0) {
      tok = strtok(0," \t");
      directory->sprintf("%s",tok);
      *directory = directory->left(directory->length()-1);
    }
    if (strcmp(tok,"cache") == 0) {
      tok = strtok(0," \t");
      tok = strtok(0," \t");
      cache->sprintf("%s",tok);
      *cache = cache->left(cache->length()-1);
    }
    if (strcmp(tok,"forwarders") == 0) {
      	while ( ((tok = strtok(0," \t")) != 0) && (strlen(tok) > 1) ) {
      		forwarders->append(tok);
      	}
    }
    if (strcmp(tok,"xfrnets") == 0) {
      	while ( ((tok = strtok(0," \t")) != 0) && (strlen(tok) > 1) ) {
      		xfrnets->append(tok);
      	}
    }

    if (strcmp(tok,"bogusns") == 0) {
      	while ( ((tok = strtok(0," \t")) != 0) && (strlen(tok) > 1) ) {
      		bogusns->append(tok);
      	}
    }
    
    if (strcmp(tok,"options") == 0) {
	tok=strtok(0," \t");
	if (strcmp(tok,"forward-only") == 0) options |= forward_only;
	if (strcmp(tok,"no-recursion") == 0) options |= no_recursion;
	if (strcmp(tok,"no-fetch_glue") == 0) options |= no_fetch_glue;
	if (strcmp(tok,"query-log") == 0) options |= query_log;
	if (strcmp(tok,"fake-iquery") == 0) options |= fake_iquery;	
    }
    if (strcmp(tok,"check-names") == 0) {
    }

  }
}

void KBindWidget::displaySettings()
{
  primaryDomain *pl;
  secondaryDomain *sl;  
  cacheedit->setText(*cache);
  diredit->setText(*directory);

  plist->clear();
  slist->clear();
  xlist->clear();
  blist->clear();

  for (pl=primaryList->first();pl!=0;pl=primaryList->next()) {
    plist->insertItem(pl->domain);
    
  } 
  for (sl=secondaryList->first();sl!=0;sl=secondaryList->next()) {
    slist->insertItem(sl->domain);
    
  } 

  if (!forwarders->isEmpty())  flist->insertStrList(forwarders);  
  xlist->insertStrList(xfrnets); 
  blist->insertStrList(bogusns); 
}


void KBindWidget::primaryClick(const char *a)
{
  primaryDomain *pl;
  ksoaedit *soa;
 

  printf("Click on : %s\n",a);

  for (pl=primaryList->first();pl!=0;pl=primaryList->next()) {
    //       plist->insertItem(pl->domain);
    if (strcmp(pl->domain,a) == 0) {
      printf("Ok ! found it !\n");
      soa= new ksoaedit(pl);
      soa->show();
    }

  } 
}

void KBindWidget::secondaryClick(const char *a)
{
  secondary *se;
  secondaryDomain *sl;
  
  printf("Click on : %s\n",a);
 
  for (sl=secondaryList->first();sl!=0;sl=secondaryList->next()) {
    //       plist->insertItem(pl->domain);
    if (strcmp(sl->domain,a) == 0) {
      printf("Ok ! found it !\n");
	  se = new secondary(sl);
 	  se->show();
    }

  } 

}


void KBindWidget::readSOA(primaryDomain *pl, QString path)
{
  char tmp[255];
  char *tok,*tok1,*tok2,*tok3;
  int nr[5];
  int a,b;
  bool found = false;
  QString lastadr,adr,temp,temp1,rl;
  records * helprecord;

  b=-1; 
  pl->data = new (QList<records>);
  pl->data->setAutoDelete(TRUE);

  QFile *file = new QFile(path);
  if(!file->open(IO_ReadOnly))
    {
      //DEBUG : 
      diredit->setText(path);  
      printf("File Not found !\n");
      return;
    }                                                      

  while (!found)
  {
    if ((file->readLine(tmp,255)) == 0) {
       debug("FATAL ERROR !");
       debug("No SOA FOUND");
       exit(-1);
    }
    //tmp=temp.simplifyWhiteSpace();
    rl=tmp;
    tok = strtok(tmp," \t");
    if (strncmp(tok,";",1) != 0) {
    	found = true;
//       if (strncmp(tok,"@",1) == 0) {
// 	lastadr = pl->domain;
//       } else {
//         lastadr=tok;
  
      
      tok1 = strtok(0," \t");
      tok2 = strtok(0," \t");
      tok3 = strtok(0," \t");
      if ((a=strcmp(tok2,"SOA") == 0) || (b=strcmp(tok3,"SOA") == 0)) {
	if (b==0) tok3=strtok(0," \t");
	pl->org = tok3;
	lastadr=tok;
	pl->rp = strtok(0," \t");
	pl->cl = tok1;
	tok = strtok(0," \t");
	found=true;
	if (strncmp(tok,"(",1)==0) {
	  a=0;
	  temp=tok;
          temp=temp.stripWhiteSpace();
          temp=temp.remove(0,1);
          if (temp.length() > 0 ) {nr[a++]=temp.toInt();  }
	  while (a != 5) {
	    if ((temp.length() > 0) && (strncmp(tok,";",1) !=0)) {
              // Line is not finnished ..
	      tok=strtok(0," \t");
	      temp=tok;
       	      temp=temp.stripWhiteSpace();
	    } else {
	      // Read new Line !
	      file->readLine(tmp,255);
	      tok = strtok(tmp," \t");
    	      temp=tok;
              temp=temp.stripWhiteSpace();
	    }

	    if ((strncmp(tok,";",1) != 0) && (temp.length() > 0)) {nr[a++]=temp.toInt(); }
	  }
	  pl->serial = nr[0];
	  pl->refresh = nr[1];
	  pl->retry = nr[2];
	  pl->expire = nr[3];
	  pl->TTL = nr[4];

	} else {
	  tok=strtok(0," \t");
	  pl->serial = atoi(tok);
	  tok=strtok(0," \t");
	  pl->refresh = atoi(tok);
	  tok=strtok(0," \t");
	  pl->retry = atoi(tok);
	  tok=strtok(0," \t");
	  pl->expire = atoi(tok);
	  tok=strtok(0," \t");
	  pl->TTL = atoi(tok);
	}
      }	
    }	 
  }
  while (file->readLine(tmp,255) != 0) {
    rl=tmp;
    tok=strtok(tmp," \t");
    tok1=strtok(0," \t");
    found=false;
    if ((strcmp(tok1,"IN") != 0) && (strcmp(tok,"IN") == 0)) { adr=lastadr;} else {adr=tok;lastadr=adr;}
    found = false; 
    helprecord=new records();
    helprecord->i=0;
    helprecord->st1="";
    helprecord->st2="";

    if (strcmp(tok1,"IN") == 0) {
      tok=strtok(0," \t");
    } else {
      tok=tok1;
    }  
    if (strcmp(tok,"NS") == 0) {
      
      temp=strtok(0," \t");
      temp=temp.stripWhiteSpace();
//      debug(adr+ " NameServer : ->"+temp+"<-");
      helprecord->type=TYPE_NS;
      helprecord->st1=temp;
      found=true;
    }
    if (strcmp(tok,"PTR") == 0) {
      temp=strtok(0," \t");
      temp=temp.stripWhiteSpace();
 //     debug(adr+ " PTR : ->"+temp+"<-");
      helprecord->type=TYPE_PTR;
      helprecord->st1=temp;
      found=true;
    }
    if (strcmp(tok,"A") == 0) {
      temp=strtok(0," \t");
      temp=temp.stripWhiteSpace();
   //   debug(adr+" A : ->"+temp+"<-");
      helprecord->type=TYPE_A;
      helprecord->st1=temp;
      found=true;
    }
    if (strcmp(tok,"MX") == 0) {
      temp=strtok(0," \t");
      temp=temp.stripWhiteSpace();
      temp1=strtok(0," \t");
      temp1=temp1.stripWhiteSpace();
      debug(adr+ " MX : ->"+temp+"<- ->"+temp1+"<-");
      helprecord->type=TYPE_MX;
      helprecord->st1=temp1;
      helprecord->i = temp.toInt(); 
      found=true;
    }
    if (strcmp(tok,"CNAME") == 0) {
      temp=strtok(0," \t");
      temp=temp.stripWhiteSpace();
 //     debug(adr + " CNAME : ->"+temp+"<-");
      helprecord->type=TYPE_CNAME;
      helprecord->st1=temp;
      found=true;
    }
    if (strcmp(tok,"HINFO") == 0) {
      temp=rl;
      b=temp.find("HINFO");
      temp=temp.remove(0,b+5);
      temp=temp.simplifyWhiteSpace();
//      debug(adr + " HINFO : -> "+temp+"<-");
      helprecord->type=TYPE_HINFO;
      helprecord->st1=temp;
      found=true;
    }
    if (strcmp(tok,"TXT") == 0) {
      temp=rl;
      b=temp.find("TXT");
      temp=temp.remove(0,b+4);
      temp=temp.simplifyWhiteSpace();
//      debug(adr+" TXT : -> "+temp+"<-");
      helprecord->type=TYPE_TXT;
      helprecord->st1=temp;
      found=true;
    }  
    if (found) {
      helprecord->owner=adr;
      pl->data->append(helprecord);
    } else {
      delete(helprecord);
    }
  }
  file->close();
}
