  /*

  kfirewall v 0.4.2

  Copyright (C) 1999 Kim Andre Norheim
  		     kim-nor@online.no

  This application is free software; you can redistribute it and/or
  modify it under the terms of the GNU Genereal Public License as
  published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  This application is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
  GNU General Public License for more details.

  */
  

#include <qlayout.h>
#include <qmultilinedit.h>
#include <qkeycode.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qstring.h>
#include <qstrlist.h>

#include <kmsgbox.h>
#include <kiconloader.h>
#include <klocale.h>

#include "kfirewall.moc"

#include "version.h"

kfirewall::kfirewall( QWidget *, const char *name )
  : KTMainWindow( name )
{
  
    interfaceChoice = "lo";
    interfacenrChoice = 0;
 
    setupMenuBar();
    setupToolBar();
    setupStatusBar();

    setupkfirewallWidget();

    setupConnect();
    startprobeInterface();

    statusbar->message(i18n("Welcome to kfirewall"), 2000);
  
};


kfirewall::~kfirewall() {

  delete file;
  delete options;
  delete help;
  delete toolbar;

};


void kfirewall::setupMenuBar() {

  file = 	new QPopupMenu();
  options = 	new QPopupMenu();

  
  file->insertItem(i18n("&Add rule"), 
  				this, SLOT(addRule()), CTRL+Key_A);
  file->insertItem(i18n("&Del rule"), 
  				this, SLOT(delRule()), CTRL+Key_D);
  file->insertSeparator();
  file->insertItem(i18n("D&elete all rules"), 
  				this, SLOT(stopAll()));
  file->insertSeparator();
  file->insertItem(i18n("&Exit"), 
  				this, SLOT(slotExit()), CTRL+Key_E);

  useMasq = options->insertItem(i18n("Masqurading on"), 
  				this, SLOT(checkMasqon()));
  options->insertItem(i18n("Masqurading entries"),
  				this, SLOT(masqEntries()));
  options->insertSeparator();
  options->insertItem(i18n("List rules"), 
  				this, SLOT(ipchainsRules()));
  options->insertSeparator();
  options->insertItem(i18n("Probe interface"),
	  			this, SLOT(startprobeInterface()));
  options->insertSeparator();
  options->insertItem(i18n("&Clear list"), 
  				this, SLOT(clearLog()));
  isMasqon = FALSE;

  QString about;
  about.sprintf ("kfirewall %s\n\n"
	  	"kfirwall is created by Kim Andre Norheim\n"
		"please send feedback to kim-nor@online.no", KFIREWALL_VERSION);
		
  help = kapp->getHelpMenu(TRUE, about);

  menubar = new KMenuBar( this, "menubar" );

  menubar->insertItem(i18n("&File"), file);
  menubar->insertItem(i18n("&Options"), options);
  menubar->insertItem(i18n("&Help"), help);

  setMenu(menubar);

};


void kfirewall::setupToolBar() {

  KIconLoader *loader = kapp->getIconLoader();
  toolbar = new KToolBar( this );

  toolbar->insertButton(loader->loadIcon("play.xpm"),add,SIGNAL(clicked()),
			this,SLOT(addRule()),TRUE,i18n("Add rule")); 
  toolbar->insertButton(loader->loadIcon("stop.xpm"),del,SIGNAL(clicked()),
			this,SLOT(delRule()),TRUE,i18n("Delete rule"));
  toolbar->setBarPos( KToolBar::Top );

  toolbar1 = addToolBar(toolbar);

};


void kfirewall::setupStatusBar() {

  statusbar = new KStatusBar( this );
  statusbar->setBorderWidth(1);

  setStatusBar( statusbar );

};


void kfirewall::setupkfirewallWidget() {

  QWidget *mainWidget = new QWidget(this);

  QBoxLayout *top = new QBoxLayout(mainWidget, QBoxLayout::LeftToRight, 7);
  QGridLayout *grid = new QGridLayout(7,10);
  top->addLayout(grid,10);

  QLabel *labelPort = new QLabel(mainWidget);
  labelPort->setText("Port:");

  addPort = new QLineEdit(mainWidget);
  addPort->setFixedHeight(addPort->sizeHint().height());
  addPort->setText("");

  grid->addMultiCellWidget(labelPort,0,0,0,1);
  grid->addMultiCellWidget(addPort,0,0,2,3);

  QLabel *labelInterface = new QLabel(mainWidget);
  labelInterface->setText("Interface:");
  grid->addMultiCellWidget(labelInterface,2,2,0,1);

  interface = new QComboBox( FALSE, mainWidget, "interface");
  interface->insertItem("lo");
  interface->insertItem("eth");
  interface->insertItem("slip");
  interface->insertItem("plip");
  interface->insertItem("ppp");
  interface->insertItem("ippp");
  interface->setFixedHeight(interface->sizeHint().height());
  connect(interface,SIGNAL(activated(int)), SLOT(interfaceActivated(int)));
  grid->addMultiCellWidget(interface,2,2,2,3);

  QLabel *labelInterfacenr = new QLabel(mainWidget);
  labelInterfacenr->setText("Interface nr:");
  grid->addMultiCellWidget(labelInterfacenr,3,3,0,1);

  interfacenr = new QComboBox( FALSE, mainWidget, "interface nr");
  interfacenr->insertItem("0");
  interfacenr->insertItem("1");
  interfacenr->insertItem("2");
  interfacenr->insertItem("3");
  interfacenr->insertItem("4");
  interfacenr->insertItem("5");
  interfacenr->setFixedHeight(interfacenr->sizeHint().height());
  connect(interfacenr,SIGNAL(activated(int)), SLOT(interfacenrActivated(int)));
  grid->addMultiCellWidget(interfacenr,3,3,2,3);

  QLabel *labelIp = 		new QLabel(mainWidget);
  QLabel *labelNetmask = 	new QLabel(mainWidget); 

  labelIp->setText("IP Adress:");
  labelNetmask->setText("Netmask:");

  ipAddr = 	new QLineEdit(mainWidget);
  netmaskAddr =	new QLineEdit(mainWidget);

  ipAddr->setFixedHeight(ipAddr->sizeHint().height());
  netmaskAddr->setFixedHeight(netmaskAddr->sizeHint().height());

  grid->addMultiCellWidget(labelIp,5,5,0,1);
  grid->addMultiCellWidget(labelNetmask,6,6,0,1);
  grid->addMultiCellWidget(ipAddr,5,5,2,3);
  grid->addMultiCellWidget(netmaskAddr,6,6,2,3);
  
  messageLog = new QListBox(mainWidget);
  
  grid->addMultiCellWidget(messageLog,0,6,5,9);

  setView(mainWidget);

};


void kfirewall::setupConnect() {

  KApplication::connect(&addp,SIGNAL(processExited(KProcess *)),
			this,SLOT(addDone()));
  KApplication::connect(&addp2,SIGNAL(processExited(KProcess *)),
			this,SLOT(addDone()));
  KApplication::connect(&delp,SIGNAL(processExited(KProcess *)),
			this,SLOT(delDone()));
  KApplication::connect(&delp2,SIGNAL(processExited(KProcess *)),
			this,SLOT(delDone()));
  KApplication::connect(&stop,SIGNAL(processExited(KProcess *)),
			this,SLOT(stopDone()));
  KApplication::connect(&masqon,SIGNAL(processExited(KProcess *)),
			this,SLOT(masqonDone()));
  KApplication::connect(&masqoff,SIGNAL(processExited(KProcess *)),
			this,SLOT(masqoffDone()));


  KApplication::connect(&rules,SIGNAL(processExited(KProcess *)),
  			this,SLOT(listRulesDone()));
  KApplication::connect(&rules,SIGNAL(receivedStdout(KProcess *, char *, int)),
  			this,SLOT(listRules(KProcess *, char *, int)));
  KApplication::connect(&rules,SIGNAL(receivedStderr(KProcess *, char *, int)),
  			this,SLOT(listRules(KProcess *, char *, int)));


  KApplication::connect(&fetchIp,SIGNAL(processExited(KProcess *)),
  			this,SLOT(probeInterfaceDone()));
  KApplication::connect(&fetchIp,SIGNAL(receivedStdout(KProcess *,char *, int)),
  			this,SLOT(probeInterface(KProcess *, char *, int)));
  KApplication::connect(&fetchIp,SIGNAL(receivedStderr(KProcess *,char *, int)),
  			this,SLOT(probeInterface(KProcess *, char *, int)));
  KApplication::connect(&fetchNetmask,SIGNAL(processExited(KProcess *)),
  			this,SLOT(probeInterfaceDone()));
  KApplication::connect(&fetchNetmask,SIGNAL(receivedStdout(KProcess *,char *, int)),
  			this,SLOT(probeInterface2(KProcess *, char *, int)));
  KApplication::connect(&fetchNetmask,SIGNAL(receivedStderr(KProcess *,char *, int)),
  			this,SLOT(probeInterface2(KProcess *, char *, int)));

  KApplication::connect(&entries,SIGNAL(receivedStdout(KProcess *,char *, int)),
  			this,SLOT(userEntries(KProcess *,char *, int)));
  KApplication::connect(&entries,SIGNAL(receivedStderr(KProcess *,char *, int)),
  			this,SLOT(userEntries(KProcess *,char *, int)));
  KApplication::connect(&entries,SIGNAL(processExited(KProcess *)),
  			this,SLOT(userEntriesDone()));

};


void kfirewall::closeEvent (QCloseEvent *) {

  kapp->quit();

};


void kfirewall::checkMasquerade() {

  ip_masquerade = fopen("/proc/net/ip_masquerade", "r");

};


void kfirewall::addRule() {

    QString ip, netmask, network, port;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmaskAddr->text()));
    port.sprintf((const char *)(addPort->text()));

    addp.clearArguments();
    addp2.clearArguments();

    if(port.length()==0) 
      QMessageBox::critical(0, "Error",
    			"You have to supply a port number.\n");
    else if(ip.length()==0 && netmask.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a IP address,\n"
			"and a netmask address.\n");
    else if(ip.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a IP address.\n");
    else if(netmask.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address and Netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address.\n");
    else if(!strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid netmask address.\n");
    else {
      addp << "ipchains" << "-A" << "input" << "-p" << "tcp" << "-s" << "0.0.0.0/0" << "-d" << network << port << "-j" << "DENY"; 
      addp2 << "ipchains" << "-A" << "input" << "-p" << "udp" << "-s" << "0.0.0.0/0" << "-d" << network << port << "-j" << "DENY"; 
    };

    bool success=addp.start();
    bool success2=addp2.start();
    if (success && success2)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start ipchains"), 2000);

};


void kfirewall::delRule() {

    QString ip, netmask, network, port;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmaskAddr->text()));
    port.sprintf((const char *)(addPort->text()));


    delp.clearArguments();
    delp2.clearArguments();

    if(port.length()==0) 
      QMessageBox::critical(0, "Error",
    			"You have to enter a port number\n");
    else if(ip.length()==0 && netmask.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a IP address,\n"
			"and a netmask address.\n");
    else if(ip.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a IP address.\n");
    else if(netmask.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address and Netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address.\n");
    else if(!strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid netmask address.\n");
    else {
      delp << "ipchains" << "-D" << "input" << "-p" << "tcp" << "-s" << "0.0.0.0/0" << "-d" << network << port << "-j" << "DENY"; 
      delp2 << "ipchains" << "-D" << "input" << "-p" << "udp" << "-s" << "0.0.0.0/0" << "-d" << network << port << "-j" << "DENY"; 
    };

    bool success=delp.start();
    bool success2=delp2.start();

    if (success && success2)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start ipchains"), 2000);

};


void kfirewall::stopAll() {

    stop.clearArguments(); 
    stop << "ipchains" << "-F";
    bool success=stop.start();

    if (success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't flush ipchains"), 2000);

};


void kfirewall::slotExit() {

  close();

};


void kfirewall::addDone() {

  if (addp.normalExit() && (addp.exitStatus()==0) && addp2.normalExit() && (addp2.exitStatus()==0)) {
    statusbar->message(i18n("Rule added"), 2000);
    QString msg;
    msg.sprintf("Deny all incoming on port %s",(const char *)(addPort->text()));
    messageLog->insertItem(msg);
    addPort->clear();
  } else
    statusbar->message(i18n("ipchains died"), 2000);
  addPort->setFocus();

};


void kfirewall::delDone() {

  if (delp.normalExit() && (delp.exitStatus()==0) && delp2.normalExit() && (delp2.exitStatus()==0)) {
    statusbar->message(i18n("Rule deleted"), 2000);
    QString msg;
    msg.sprintf("Allow all incoming on port %s",(const char *)(addPort->text()));
    messageLog->insertItem(msg);
    addPort->clear();
  } else
    statusbar->message(i18n("ipchains died"), 2000);
  addPort->setFocus();

};


void kfirewall::stopDone() {

  if (stop.normalExit() && (stop.exitStatus()==0)) {
    statusbar->message(i18n("All rules flushed"), 2000);
    messageLog->insertItem("All ports are now open");
    addPort->setFocus();
  } else
    statusbar->message(i18n("ipchains died"), 2000);

};


void kfirewall::checkMasqon() {
  
  isMasqon = !isMasqon;
  options->setItemChecked(useMasq, isMasqon);

  checkMasquerade();
  if(ip_masquerade==NULL)
    QMessageBox::critical(0, "Error",
    			"You haven't support for IP masquerade\n"
			"in your kernel. Please recompile.\n");
  else {			
    if (isMasqon == FALSE) {
      QString network;
      network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmaskAddr->text()));

      masqoff.clearArguments();

      masqoff << "ipchains" << "-D" << "forward" << "-j" << "MASQ" << "-s" << network << "-d" << "0.0.0.0/0"; 

      bool success=masqoff.start();
      if (success) 
        statusbar->message(i18n("Running..."), 2000);
      else
        statusbar->message(i18n("Couldn't start ipchains"), 2000);
    } else {
      QString network;
      network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmaskAddr->text()));

      masqon.clearArguments();

      masqon << "ipchains" << "-A" << "forward" << "-j" << "MASQ" << "-s" << network << "-d" << "0.0.0.0/0"; 

      bool success=masqon.start();
      if (success)
        statusbar->message(i18n("Running..."), 2000);
      else
        statusbar->message(i18n("Couldn't start ipchains"), 2000);
   };
  };

};


void kfirewall::masqonDone() {

  if (masqon.normalExit() && (masqon.exitStatus()==0)) {
    statusbar->message(i18n("Masqurading turned on"), 2000);
    QString msg;
    msg.sprintf("Allow all outgoing");
    messageLog->insertItem(msg);
    addPort->clear();
  } else {
    statusbar->message(i18n("ipchains died"), 2000);
    isMasqon = FALSE;
    options->setItemChecked(useMasq, isMasqon);
  };
  addPort->setFocus();

};


void kfirewall::masqoffDone() {

  if (masqoff.normalExit() && (masqoff.exitStatus()==0)) {
    statusbar->message(i18n("Masqurading turned off"), 2000);
    QString msg;
    msg.sprintf("Deny all outgoing");
    messageLog->insertItem(msg);
    addPort->clear();
  } else {
    statusbar->message(i18n("ipchains died"), 2000);
    isMasqon = FALSE;
    options->setItemChecked(useMasq, isMasqon);
  };
  addPort->setFocus();

};


void kfirewall::clearLog() {

  messageLog->clear();
  addPort->setFocus();

};


void kfirewall::startlistRules() {

    rules.clearArguments();

    rules << "ipchains" << "-L";

    bool success=rules.start(KProcess::NotifyOnExit,
  			   KProcess::AllOutput);
    if (success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start ipchains"), 2000);

};


void kfirewall::ipchainsRules() {

  masqList = new QWidget();
  masqList->resize(550,420);
  masqList->setCaption("current ipchains rules");

  QBoxLayout *top = new QBoxLayout(masqList, QBoxLayout::LeftToRight, 5);
  QGridLayout *grid = new QGridLayout(5,5);
  top->addLayout(grid,5);
   
  masqBox = new QListBox(masqList);
  grid->addMultiCellWidget(masqBox,0,3,0,4);

  QPushButton *btnRefresh = new QPushButton(masqList);
  btnRefresh->setText("Refresh");
  btnRefresh->setFixedHeight(btnRefresh->sizeHint().height());
  connect(btnRefresh,SIGNAL(clicked()), this, SLOT(startlistRules()));
  grid->addWidget(btnRefresh,4,0);

  QPushButton *btnClose = new QPushButton(masqList);
  btnClose->setText("Close");
  btnClose->setFixedHeight(btnClose->sizeHint().height());
  connect(btnClose,SIGNAL(clicked()), this, SLOT(closeipchainsRules()));
  grid->addWidget(btnClose,4,1);
 
  masqList->show();
  setView(masqList);

};


void kfirewall::closeipchainsRules() {

  masqList->close();

};


void kfirewall::listRulesDone() {

  if (rules.normalExit() && (rules.exitStatus()==0)) 
    statusbar->message(i18n("Listing all rules..."), 2000);
  else 
    statusbar->message(i18n("Couldn't list all rules"), 2000);

};


void kfirewall::listRules(KProcess *, char *data, int len) {

  if (len<0)
    return;
  static QString remainder;
  QString list;

  char dst[len+1];
  memmove(dst,data,len);
  dst[len]=0;

  list=remainder+dst;
  QStrList lines;
  int index=0;
  int newindex=0;

  while (1)
  {
    newindex=list.find('\n',index);
    if(newindex==-1) {
      remainder=list.right(list.length()-index);
      break;
    } else {
      lines.append(list.mid(index,newindex-index));
      index=newindex+1;
    };
  };

  if(lines.count()>0) 
    masqBox->insertStrList(&lines);

 masqBox->insertItem(remainder.data());
 masqBox->setTopItem(masqBox->count()-masqBox->numItemsVisible());

};


void kfirewall::startprobeInterface() {

  fetchIp.clearArguments();
  fetchNetmask.clearArguments();

  if(interfaceChoice=="lo") {
    ipAddr->clear();
    netmaskAddr->clear();
    fetchIp << "getip" << "lo"; 
    fetchNetmask << "getloop" << "lo";
  } else if(interfaceChoice=="eth") {
    QString ethdevice;
    ethdevice.sprintf("eth%d", interfacenrChoice);
    ipAddr->clear();
    netmaskAddr->clear();
    fetchIp << "getip" << ethdevice;
    fetchNetmask << "getnetmask" << ethdevice; 
  } else if(interfaceChoice=="slip") {
    QString slipdevice;
    slipdevice.sprintf("slip%d", interfacenrChoice);
    ipAddr->clear();
    netmaskAddr->clear();
    fetchIp << "getip" << slipdevice;
    fetchNetmask << "getnetmask" << slipdevice;
  } else if(interfaceChoice=="plip") {
    QString plipdevice;
    plipdevice.sprintf("plip%d", interfacenrChoice);
    ipAddr->clear();
    netmaskAddr->clear();
    fetchIp << "getip" << plipdevice;
    fetchNetmask << "getnetmask" << plipdevice;
  } else if(interfaceChoice=="ppp") { 
    QString pppdevice;
    pppdevice.sprintf("ppp%d", interfaceChoice);
    ipAddr->clear();
    netmaskAddr->clear(); 
    fetchIp << "getip" << pppdevice;
    fetchNetmask << "getnetmask" << pppdevice;
  } else if(interfaceChoice=="ippp") { 
    QString ipppdevice;
    ipppdevice.sprintf("ippp%d", interfaceChoice);
    ipAddr->clear();
    netmaskAddr->clear();
    fetchIp << "getip" << ipppdevice;
    fetchNetmask << "getnetmask" << ipppdevice;
  } else {
    ipAddr->setText("Couldn't probe");
    netmaskAddr->setText("Couldn't probe");
  }; 

  bool success=fetchIp.start(KProcess::NotifyOnExit,
  			   KProcess::AllOutput);
  bool success2=fetchNetmask.start(KProcess::NotifyOnExit,
  				KProcess::AllOutput);

  if (success && success2)
    statusbar->message(i18n("Running..."), 2000);
  else
    statusbar->message(i18n("Couldn't start probing"), 2000);

};


void kfirewall::probeInterfaceDone() {

  if (fetchIp.normalExit() && (fetchIp.exitStatus()==0) && fetchNetmask.normalExit() && (fetchNetmask.exitStatus()==0)) 
    statusbar->message(i18n("Probe completed successfully"), 2000);
  else {
    statusbar->message(i18n("ifconfig, awk and sed died"), 2000);
  };

};


void kfirewall::probeInterface(KProcess *, char *data, int len) {

  if (len<0) {
    ipAddr->setText("Couldn't get IP");
    return;
  };
  static QString remainder;
  QString ip;

  char ipdst[len+1];
  memmove(ipdst,data,len);
  ipdst[len]=0;

  ip=remainder+ipdst;

  if(ip.length()==0) {
    ipAddr->setMaxLength(17);
    QMessageBox::critical(0, "Couldn't get IP",
    			"kfirewall couldn't get the IP address.\n");
  } else if(ip.length()>17) {
    ipAddr->setMaxLength(17);
    QMessageBox::critical(0, "Couldn't probe",
    			"kfirewall couldn't probe the device.\n");
  } else {
    ipAddr->setMaxLength(ip.length()-1); 
    ipAddr->setText(ip);
  };

};


void kfirewall::probeInterface2(KProcess *, char *data, int len) {

  if (len<0) {
    netmaskAddr->setText("Couldn't get netmask");
    return;
  };
  static QString remainder;
  QString netmask;

  char netmaskdst[len+1];
  memmove(netmaskdst,data,len);
  netmaskdst[len]=0;

  netmask=remainder+netmaskdst;

  if(netmask.length()==0) {
    netmaskAddr->setMaxLength(17);
  } else if(netmask.length()>17) {
    netmaskAddr->setMaxLength(17);
  } else {
    netmaskAddr->setMaxLength(netmask.length()-1); 
    netmaskAddr->setText(netmask);
  };

};


void kfirewall::interfaceActivated(int index) {

  ipAddr->clear();
  netmaskAddr->clear();

  ipAddr->setMaxLength(17);
  netmaskAddr->setMaxLength(17);

  switch(index) {
  default:
  case 0:
    interfaceChoice = "lo";
    break;
  case 1:
    interfaceChoice = "eth";
    break;
  case 2:
    interfaceChoice = "slip";
    break;
  case 3:
    interfaceChoice = "plip";
    break;
  case 4:
    interfaceChoice = "ppp";
    break;
  case 5:
    interfaceChoice = "ippp";
    break;
  };

};


void kfirewall::interfacenrActivated(int index) {

  ipAddr->clear();
  netmaskAddr->clear();

  ipAddr->setMaxLength(17);
  netmaskAddr->setMaxLength(17);

  switch(index) {
  default:
  case 0:
    interfacenrChoice = 0;
    break;
  case 1:
    interfacenrChoice = 1;
    break;
  case 2:
    interfacenrChoice = 2;
    break;
  case 3:
    interfacenrChoice = 3;
    break;
  case 4:
    interfacenrChoice = 4;
    break;
  case 5:
    interfacenrChoice = 5;
    break;
  };

};


void kfirewall::closemasqEntries() {

  masqWidget->close();
  
};


void kfirewall::startmasqEntries() {

  entries.clearArguments();

  entries << "ipchains" << "-L" << "-M";

  bool success=entries.start(KProcess::NotifyOnExit,
  			   KProcess::AllOutput);
  if (success)
    statusbar->message(i18n("Running..."), 2000);
  else
    statusbar->message(i18n("Couldn't start ipchains"), 2000);

};


void kfirewall::userEntries(KProcess *, char *data, int len) {

  if (len<0)
    return;
  static QString remainder;
  QString list;

  char dst[len+1];
  memmove(dst,data,len);
  dst[len]=0;

  list=remainder+dst;
  QStrList lines;
  int index=0;
  int newindex=0;

  while (1)
  {
    newindex=list.find('\n',index);
    if(newindex==-1) {
      remainder=list.right(list.length()-index);
      break;
    } else {
      lines.append(list.mid(index,newindex-index));
      index=newindex+1;
    };
  };

  if(lines.count()>0) 
    masqBox->insertStrList(&lines);

 masqBox->insertItem(remainder.data());
 masqBox->setTopItem(masqBox->count()-masqBox->numItemsVisible());

};


void kfirewall::userEntriesDone() {

  if (entries.normalExit() && (entries.exitStatus()==0)) 
    statusbar->message(i18n("Listing all entries..."), 2000);
  else 
    statusbar->message(i18n("Couldn't list all entries"), 2000);

};


void kfirewall::masqEntries() {

  checkMasquerade();
  if(ip_masquerade==NULL)
    QMessageBox::critical(0, "Error",
    			"You haven't support for IP masquerade\n"
			"in your kernel. Please recompile.\n");
  else {			
    masqWidget = new QWidget();
    masqWidget->resize(550,420);
    masqWidget->setCaption("current users on the internet");

    QBoxLayout *top = new QBoxLayout(masqWidget, QBoxLayout::LeftToRight, 5);
    QGridLayout *grid = new QGridLayout(5,5);
    top->addLayout(grid,5);
   
    masqBox = new QListBox(masqWidget);
    grid->addMultiCellWidget(masqBox,0,3,0,4);

    QPushButton *btnRefresh = new QPushButton(masqWidget);
    btnRefresh->setText("Refresh");
    btnRefresh->setFixedHeight(btnRefresh->sizeHint().height());
    connect(btnRefresh,SIGNAL(clicked()), this, SLOT(startmasqEntries()));
    grid->addWidget(btnRefresh,4,0);

    QPushButton *btnClose = new QPushButton(masqWidget);
    btnClose->setText("Close");
    btnClose->setFixedHeight(btnClose->sizeHint().height());
    connect(btnClose,SIGNAL(clicked()), this, SLOT(closemasqEntries()));
    grid->addWidget(btnClose,4,1);
 
    masqWidget->show();
    setView(masqWidget);
  };

};
