/***************************************************************************
                          khbuttonpair.cpp  -  description
                             -------------------                                         
    begin                : Wed Aug 4 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include "khbuttonpair.h"

KHButtonPair::KHButtonPair( QWidget* parent, const char* name ) : QButton( parent, name ){
		
		bbox = new QButtonGroup;
		bbox->setExclusive( true );

		hbox = new QBoxLayout( this, QBoxLayout::LeftToRight );

		lb = new QCheckBox( this );														
		lb->setMinimumSize( lb->sizeHint() );
		// maximum size must be set to activate alignment
		lb->setMaximumSize( lb->sizeHint().width() + 10, 100 );
		bbox->insert( lb );
		hbox->addWidget( lb, AlignLeft | AlignVCenter );

		spacing = 15;
		hbox->addSpacing( spacing );

		rb = new QCheckBox( this );				
		rb->setMinimumSize( rb->sizeHint() );
		rb->setMaximumSize( rb->sizeHint().width() + 10, 100 );
		bbox->insert( rb );
		hbox->addWidget( rb, AlignRight | AlignVCenter );

		// initially, the left button should be pressed
		bbox->setButton( 0 );
		pressedButton = 0;

		connect (bbox, SIGNAL	( pressed( int ) ),
						 this, SLOT		( emitPressed( int ) ) );
		connect (bbox, SIGNAL	( released( int ) ),
						 this, SLOT		( emitReleased( int ) ) );
		connect (bbox, SIGNAL	( clicked( int ) ),
						 this, SLOT		( emitClicked( int ) ) );
		
}

KHButtonPair::~KHButtonPair(){
	//debug( "destroying KHButtonPair" );
}

QLayout *KHButtonPair::layout() {
	return hbox;
}

void KHButtonPair::emitPressed( int button ) {
	emit pressed();
	pressedButton = button;
}

void KHButtonPair::emitReleased( int button ) {
	emit released();
}

void KHButtonPair::emitClicked( int button ) {
	emit clicked();
};

void KHButtonPair::setLeftButtonDown( bool value ){
	if ( value ) bbox->setButton( 0 );
	else bbox->setButton( 1 );
}

bool KHButtonPair::leftPressed(){
	if ( pressedButton == 0 ) return true;
	else return false;
}

/**  */
QSize KHButtonPair::size(){
	int width, height;
	width = lb->size().width() + rb->size().width() + spacing;
	height = lb->size().height();
	return QSize( width, height );
}





