/***************************************************************************
                          khdockwidget.h  -  description                              
                             -------------------                                         
    begin                : Mon Aug 9 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KHDOCKWIDGET_H
#define KHDOCKWIDGET_H

#include <sensorid.h>
#include <qlabel.h>

class KHDisplayWidget;

/**This widget is basically a qlabel. It has overridden methods for
	*handling mouse clicks and repaint directives, so it can be used
	*as a docking widget with some other functionality than merely displaying.
	*It also has been added two slots for connection with the Winbond class, in such a way
	*that it can sort out from whom the caught signals have been sent.
  *@author Ruediger Anlauf
	*@short a qlabel derived class for docking to the panel
  */

class KHDockWidget : public QLabel  {

Q_OBJECT

public:
	/** constructor */
	KHDockWidget( KHDisplayWidget *mainwidget );

	/** destructor */
	~KHDockWidget();

protected:
	/** event filter which filters out mouse clicks and reacts by
		* either ending the application or showing the main widget
		*/
	bool event( QEvent* event );

	/** repaints the widget by calling paintEvent() directly */
	void repaint();

protected:
	/** pointer to the application's main widget, so that it can be
		* shown if the user clicks the left mouse button
		*/
	KHDisplayWidget *mainwidget;

protected slots:
	/** slot for displaying int numbers, being aware of the sender */
	void display( int, SensorId );

	/** slot for displaying float numbers, being aware of the sender */
	void display( float, SensorId );

	/** save status for session manager */
	void saveMyself();

};

#endif















