/***************************************************************************
                          khtab3.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Aug 21 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "khtab3.h"

KHTab3::KHTab3( QWidget *parent, const char* name ) : QWidget( parent, name ){

	d = new KHTab3Private;

	config = kapp->getConfig();

	d->toplayout = new QBoxLayout( this, QBoxLayout::Down, 12, 0 );

  d->group = new QGroupBox( i18n( "Sensor 1" ), this );
	d->toplayout->addWidget( d->group );

	d->bg = new QButtonGroup( this );
	d->bg->hide();

	d->hbox = new QBoxLayout( d->group, QBoxLayout::Down, 12, 0 );
	d->hbox->addSpacing( 12 );

	d->rb = new QRadioButton( i18n( "Thermistor" ), d->group );
	d->rb->setMinimumHeight( d->rb->sizeHint().height() );
	d->hbox->addWidget( d->rb );
	d->bg->insert( d->rb );

	d->rb = new QRadioButton( i18n( "Transistor" ), d->group );
	d->rb->setMinimumHeight( d->rb->sizeHint().height() );
	d->hbox->addWidget( d->rb );
	d->bg->insert( d->rb );

	d->rb = new QRadioButton( i18n( "PII Thermal Diode" ), d->group );
	d->rb->setMinimumHeight( d->rb->sizeHint().height() );
	d->hbox->addWidget( d->rb );
	d->bg->insert( d->rb );
	connect( d->bg,	SIGNAL( pressed( int ) ),
					 this,	SLOT( writeSensor1Type( int ) ) );
	config->setGroup( "SensorTypes" );
	d->bg->setButton( config->readNumEntry( SensorKeys[0], 0 ) );

	d->bg = new QButtonGroup( this );
	d->bg->hide();
	
	d->toplayout->addSpacing( 12 );
	d->group = new QGroupBox( i18n( "Sensor 2" ), this );
	d->toplayout->addWidget( d->group );

	d->hbox = new QBoxLayout( d->group, QBoxLayout::Down, 12, 0 );
	d->hbox->addSpacing( 12 );

	d->rb = new QRadioButton( i18n( "Thermistor" ), d->group );
	d->rb->setMinimumHeight( d->rb->sizeHint().height() );
	d->hbox->addWidget( d->rb );
	d->bg->insert( d->rb );

	d->rb = new QRadioButton( i18n( "Transistor" ), d->group );
	d->rb->setMinimumHeight( d->rb->sizeHint().height() );
	d->hbox->addWidget( d->rb );
	d->bg->insert( d->rb );

	d->rb = new QRadioButton( i18n( "PII Thermal Diode" ), d->group );
	d->rb->setMinimumHeight( d->rb->sizeHint().height() );
	d->hbox->addWidget( d->rb );
	d->bg->insert( d->rb );
	connect( d->bg,	SIGNAL( pressed( int ) ),
					 this,	SLOT( writeSensor2Type( int ) ) );
	config->setGroup( "SensorTypes" );
	d->bg->setButton( config->readNumEntry( SensorKeys[1], 0 ) );


	d->bg = new QButtonGroup( this );
	d->bg->hide();

	d->toplayout->addSpacing( 12 );
	d->group = new QGroupBox( i18n( "Sensor 3" ), this );
	d->toplayout->addWidget( d->group );

	d->hbox = new QBoxLayout( d->group, QBoxLayout::Down, 12, 0 );
	d->hbox->addSpacing( 12 );

	d->rb = new QRadioButton( i18n( "Thermistor" ), d->group );
	d->rb->setMinimumHeight( d->rb->sizeHint().height() );
	d->hbox->addWidget( d->rb );
	d->bg->insert( d->rb );

	d->rb = new QRadioButton( i18n( "Transistor" ), d->group );
	d->rb->setMinimumHeight( d->rb->sizeHint().height() );
	d->hbox->addWidget( d->rb );
	d->bg->insert( d->rb );

	d->rb = new QRadioButton( i18n( "PII Thermal Diode" ), d->group );
	d->rb->setMinimumHeight( d->rb->sizeHint().height() );
	d->hbox->addWidget( d->rb );
	d->bg->insert( d->rb );
	connect( d->bg,	SIGNAL( pressed( int ) ),
					 this,	SLOT( writeSensor3Type( int ) ) );
	config->setGroup( "SensorTypes" );
	d->bg->setButton( config->readNumEntry( SensorKeys[2], 0 ) );

	d->toplayout->activate();
}


KHTab3::~KHTab3(){
	//debug( "destroying KHTab3" );
	delete d;
}


void KHTab3::writeSensor1Type( int type ){
	config->setGroup( "SensorTypes" );
	config->writeEntry( SensorKeys[0], type );
}


void KHTab3::writeSensor2Type( int type ){
	config->setGroup( "SensorTypes" );
	config->writeEntry( SensorKeys[1], type );
}


void KHTab3::writeSensor3Type( int type ){
	config->setGroup( "SensorTypes" );
	config->writeEntry( SensorKeys[2], type );
}











