/************************************************************************
 * kinst - KDE Application Installer - install.cpp                      *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <qwidget.h>
#include <qmessagebox.h>

#include "install.h"
#include "stringfunc.h"

#ifndef EOL
#define EOL 10
#endif

tKIFInstall::tKIFInstall(char* SourceFileDir, QWidget* parent)
{
  char Temp_Filename[FILENAME_MAX];

  InstallCommand_LogFile = NULL;

  tmpnam(Temp_Filename);
#ifdef _DEBUG_
  printf("KIFInstall:  Temp_Filename : %s\n", Temp_Filename);
#endif

  strncpy(Tmp_LogFileName, Temp_Filename, FILENAME_MAX);

  _SourceFileDir = SourceFileDir;

  guiparent = parent;
}

tKIFInstall::~tKIFInstall()
{
  delete InstallOptions;

  if(!(InstallCommand_LogFile == NULL)) fclose(InstallCommand_LogFile);
  InstallCommand_LogFile = NULL;
}

int tKIFInstall::Read_Line(char* Readed_Line, int length)
{
  char Readed_Char;
  int i = 0;

  Readed_Char = 0;

  while((!feof(InstallCommand_LogFile)) && (!(Readed_Char == EOL)) &&
	(i < length))
    {
      if(fread(&Readed_Char,sizeof(char),1,InstallCommand_LogFile) < 1)
	return(0);
      if(!(Readed_Char == EOL))
	Readed_Line[i] = Readed_Char; else Readed_Line[i] = 0;
      i++;
    }

  return(1);
}

int tKIFInstall::Open_LogFile()
{
  if(InstallCommand_LogFile == NULL)
    InstallCommand_LogFile = fopen(Tmp_LogFileName, "r");
  if(InstallCommand_LogFile == NULL) return(0); else return(1);
}

void tKIFInstall::Close_LogFile()
{
  if(!(InstallCommand_LogFile == NULL)) fclose(InstallCommand_LogFile);
  InstallCommand_LogFile = NULL;
}

int tKIFInstall::CheckFileExist(char* filename)
{
  FILE* check_dummy;

  if(strlen(filename) == 0) return(0);

#ifdef _DEBUG_
  printf("Check file exist : %s\n", filename);
#endif

  check_dummy = fopen(filename, "r");

  if(errno == ENOENT)
    {
      if(check_dummy != NULL) fclose(check_dummy);
      return(0);
    } 
  else 
    {
      if(check_dummy != NULL) fclose(check_dummy);
      return(1);
    }
}

int tKIFInstall::CheckRPMExist(char* RPM_Name)
{
  if(strlen(RPM_Name) == 0) return(0);

#ifdef _DEBUG_
  printf("Check RPM exist : %s\n", RPM_Name);
#endif

  char InvokeCommand[1024];
  char* Line;
  int err;
  unsigned int i;

  strncpy(InvokeCommand, "rpm", 1024);
  _strncat(InvokeCommand, " -q \"", 1024);
  _strncat(InvokeCommand, RPM_Name, 1024);
  _strncat(InvokeCommand, "\" &> ", 1024);
  _strncat(InvokeCommand, Tmp_LogFileName, 1024);

  err = system(InvokeCommand);

  if(err == 127)
    {
      fprintf(stderr, _i18n("Error invoking shell.\n"));
      QMessageBox::warning(guiparent, "kinst",
			   _i18n("Error invoking shell.\n"));
      return(0);
    }
  if(err == -1)
    {
      fprintf(stderr, _i18n("General failure while utilizing rpm.\n"));
      QMessageBox::warning(guiparent, "kinst",
			   _i18n("General failure while utilizing rpm.\n"));
      return(0);
    }

  if(!Open_LogFile()) return(0);

  // Check the log
  Line = InvokeCommand;
  Read_Line(Line, 1024);
  for(i = 0 ; i < strlen(RPM_Name) ; i++)
    if(Line[i] != RPM_Name[i]) return(0);

  Close_LogFile();

  return(1);
}

int tKIFInstall::Install_TGZ(char* TGZ_filename, char* install_to)
{
  char CompleteTGZPath[1024];
  char InvokeCommand[1024];
  char Log_Read;
  char orig_cwd[FILENAME_MAX];
  int err;

#ifdef _DEBUG_
  printf("_SourceFileDir : %s\n", _SourceFileDir);
#endif

  strncpy(CompleteTGZPath, _SourceFileDir, 1024);
  _strncat(CompleteTGZPath, "/", 1024);
  _strncat(CompleteTGZPath, TGZ_filename, 1024);

#ifdef _DEBUG_
  printf("CompleteTGZPath : %s\n", CompleteTGZPath);
#endif

  strncpy(InvokeCommand, "tar xfz \"", 1024);
  _strncat(InvokeCommand, CompleteTGZPath, 1024);
  _strncat(InvokeCommand, "\" &> ", 1024);
  _strncat(InvokeCommand, Tmp_LogFileName, 1024);

#ifdef _DEBUG_
  printf("TAR GZIP Install-Command : %s\n", InvokeCommand);
#endif

  getcwd(orig_cwd, FILENAME_MAX);

  if(!(mkdir(install_to, 0755) == 0))
    {
      fprintf(stderr, _i18n("Warning: Unable to create directory %s\n"), install_to);
    }
  if(!(chdir(install_to) == 0))
    {
      fprintf(stderr, _i18n("Error changing to directory %s\n"), install_to);
      QMessageBox::warning(guiparent, "kinst",
			   _i18n("The specified directory does not exist and could not be created"));
      return(0);
    }

  err = system(InvokeCommand);

  if(err == 127)
    {
      fprintf(stderr, _i18n("Error invoking shell.\n"));
      QMessageBox::warning(guiparent, "kinst",
			   _i18n("Error invoking shell.\n"));
      return(0);
    }
  if(err == -1)
    {
      fprintf(stderr, _i18n("General failure while utilizing tar.\n"));
      QMessageBox::warning(guiparent, "kinst",
			   _i18n("General failure while utilizing tar.\n"));
      return(0);
    }

  if(!Open_LogFile()) return(0);

  // Is the log empty? No -> Error !
  if(fread(&Log_Read, 1, 1, InstallCommand_LogFile) != 0)
    {
      fprintf(stderr, _i18n("TAR returned with following errors:\n"));
      fprintf(stderr, "%c", Log_Read);
      while(!feof(InstallCommand_LogFile))
	{
	  fread(&Log_Read, 1, 1, InstallCommand_LogFile);
	  fprintf(stderr, "%c", Log_Read);
	}
      Close_LogFile();
      return(0);
    }

  Close_LogFile();

  chdir(orig_cwd);

  return(1);
}

int tKIFInstall::Install_RPM(char* RPM_filename, char* install_to)
{
  char CompleteRPMPath[1024];
  char InvokeCommand[1024];
  char Log_Read;
  int err;

#ifdef _DEBUG_
  printf("_SourceFileDir : %s\n", _SourceFileDir);
#endif

  strncpy(CompleteRPMPath, _SourceFileDir, 1024);
  _strncat(CompleteRPMPath, "/", 1024);
  _strncat(CompleteRPMPath, RPM_filename, 1024);

#ifdef _DEBUG_
  printf("CompleteRPMPath : %s\n", CompleteRPMPath);
#endif

  strncpy(InvokeCommand, "rpm", 1024);
  if(strlen(install_to) != 0)
    {
      _strncat(InvokeCommand, " --prefix ", 1024);
      _strncat(InvokeCommand, install_to, 1024);
    }
  _strncat(InvokeCommand, " -i \"", 1024);
  _strncat(InvokeCommand, CompleteRPMPath, 1024);
  _strncat(InvokeCommand, "\" &> ", 1024);
  _strncat(InvokeCommand, Tmp_LogFileName, 1024);

#ifdef _DEBUG_
  printf("RPM Install-Command : %s\n", InvokeCommand);
#endif

  if (strlen(install_to) != 0)
    if (!(mkdir(install_to, 0755) == 0))
      fprintf(stderr, _i18n("Warning: Unable to create directory %s\n"), install_to);
      
  err = system(InvokeCommand);

  if(err == 127)
    {
      fprintf(stderr, _i18n("Error invoking shell.\n"));
      QMessageBox::warning(guiparent, "kinst",
			   _i18n("Error invoking shell.\n"));
      return(0);
    }
  if(err == -1)
    {
      fprintf(stderr, _i18n("General failure while utilizing rpm.\n"));
      QMessageBox::warning(guiparent, "kinst",
			   _i18n("General failure while utilizing rpm.\n"));
      return(0);
    }

  if(!Open_LogFile()) return(0);

  // Is the log empty? No -> Error !
  if(fread(&Log_Read, 1, 1, InstallCommand_LogFile) != 0)
    {
      fprintf(stderr, _i18n("RPM returned with following errors:\n"));
      fprintf(stderr, "%c", Log_Read);
      while(!feof(InstallCommand_LogFile))
	{
	  fread(&Log_Read, 1, 1, InstallCommand_LogFile);
	  fprintf(stderr, "%c", Log_Read);
	}
      Close_LogFile();
      return(0);
    }

  Close_LogFile();

  return(1);
}

int tKIFInstall::Install(tKIFOptions given_options, char* destfolder)
{
  int inst_err;
  char CompleteCheckPath[FILENAME_MAX];

  inst_err = 0;

  // Install a TGZ
  if(strcasecmp(given_options.SourceFileType, "TGZ") == 0)
    {
      if(strlen(given_options.SourceFile) != 0)
	{
	  strncpy(CompleteCheckPath, destfolder, FILENAME_MAX);
	  if(CompleteCheckPath[strlen(destfolder) - 1] != '/')
	    _strncat(CompleteCheckPath, "/", FILENAME_MAX);
	  _strncat(CompleteCheckPath, given_options.CheckPriorFile,
		   FILENAME_MAX);
	} else strcpy(CompleteCheckPath, "");
      if(!CheckFileExist(CompleteCheckPath))
	inst_err = Install_TGZ(given_options.SourceFile, destfolder);
      else inst_err = 4;
    }

  // Install a RPM
  if(strcasecmp(given_options.SourceFileType, "RPM") == 0)
    {
      if(destfolder[strlen(destfolder) - 1] == '/')
	destfolder[strlen(destfolder) - 1] = 0;
      if(!CheckRPMExist(given_options.CheckPriorRPM))
	inst_err = Install_RPM(given_options.SourceFile, destfolder);
      else inst_err = 4;
    }

  if(remove(Tmp_LogFileName) != 0) fprintf(stderr,
					   _i18n("Warning: Could not remove temporary file\n"));

  return(inst_err);
}

int tKIFInstall::Install(tKIFOptions given_options, char* destfolder,
			 int extnr)
{
  int inst_err;
  char CompleteCheckPath[FILENAME_MAX];

  inst_err = 0;

  // Install a TGZ
  if(strcasecmp(given_options.SourceFileType, "TGZ") == 0)
    {
      if(strlen(given_options.SourceFile2[extnr]) != 0)
	{
	  strncpy(CompleteCheckPath, destfolder, FILENAME_MAX);
	  if(CompleteCheckPath[strlen(destfolder) - 1] != '/')
	    _strncat(CompleteCheckPath, "/", FILENAME_MAX);
	  _strncat(CompleteCheckPath, given_options.CheckPriorFile2[extnr],
		   FILENAME_MAX);
	} else strcpy(CompleteCheckPath, "");
      if(!CheckFileExist(CompleteCheckPath))
	inst_err = Install_TGZ(given_options.SourceFile2[extnr], destfolder);
      else inst_err = 4;
    }

  // Install a RPM
  if(strcasecmp(given_options.SourceFileType, "RPM") == 0)
    {
      if(destfolder[strlen(destfolder) - 1] == '/')
	destfolder[strlen(destfolder) - 1] = 0;
      if(!CheckRPMExist(given_options.CheckPriorRPM2[extnr]))
	inst_err = Install_RPM(given_options.SourceFile2[extnr], destfolder);
      else inst_err = 4;
    }

  if(remove(Tmp_LogFileName) != 0) fprintf(stderr,
					   _i18n("Warning: Could not remove temporary file\n"));

  return(inst_err);
}
