/************************************************************************
 * kcreateinst - part of kinst package - main.cpp                       *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include <stdio.h>
#include <kapp.h>
#include <qpushbt.h>

#include "locale.h"
#include "gui.h"

/*
void help(void)
{
  printf(_i18n("Usage: kinst -f infofile\n"));
  printf(_i18n("   or: kinst -p packagefile\n"));
  printf(_i18n("       kinst --version  prints program version\n"));
}
*/

int main(int argc, char *argv[])
{
  int kapp_err;

  kapp_err = 1;

  KApplication* a;

  a = new KApplication(argc, argv);

  kcreateinstMainWidget* kcreateinstAppWidget = new kcreateinstMainWidget();

  if(argc > 1)
    if(strcmp(argv[1], "--version") == 0)
      {
	printf("kcreateinst (kinst) ");
#ifdef VERSION
	printf(VERSION);
#else
	printf("(unknown version)");
#endif
	printf("\n");
	exit(0);
      }

  // Run the Application
  a->setMainWidget(kcreateinstAppWidget);

  kcreateinstAppWidget->show();

  kapp_err = a->exec();

  return(kapp_err);
}
