/***************************************************************************
                          configeditdialog.h  -  description
                             -------------------
    begin                : Sat May 15 13:31:44 MEST 1999

    copyright            : (C) 1999 by Andreas Heck
    email                : aheck@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _CONFIGEDITDIALOG_H_
#define _CONFIGEDITDIALOG_H_

#include "liloconfig.h"

#include <qdialog.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <kapp.h>
#include <qstring.h>
#include <qgroupbox.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <qtooltip.h>

class ConfigEditDialog : public QDialog
{
  Q_OBJECT

public:

  ConfigEditDialog( QWidget *parent=0, const char *name=0, bool addMode=false );

  void setConfig( OSProperties *osEntry );

  QString getLabel();
  bool isLinux();
  QString getPartition();
  QString getKernel();
  QString getAppend();

private slots:

  void osChange();
  void nameChanged(const char*);
  void changeKernel();
  void kernelChanged(const char*);

private:

  QGroupBox *group;
  QPushButton *okButton, *cancelButton, *kernelButton;
  QLabel *nameLabel, *osLabel, *partitionLabel, *kernelLabel, *appendLabel;
  QLineEdit *nameEdit, *partitionEdit, *kernelEdit, *appendEdit;
  QComboBox *osComboBox;
  QString caption;

};

#endif