/***************************************************************************
                          configeditdialog.cpp  -  description
                             -------------------
    begin                : Sat May 15 13:31:44 MEST 1999

    copyright            : (C) 1999 by Andreas Heck
    email                : aheck@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "configeditdialog.h"

ConfigEditDialog::ConfigEditDialog( QWidget *parent, const char *name, bool addMode )
  : QDialog( parent, name, TRUE )
{
  okButton = new QPushButton(i18n("OK"), this);
  okButton->setGeometry(10,210, 100, 25);
  connect( okButton, SIGNAL(clicked()), SLOT(accept()) );

  cancelButton = new QPushButton(i18n("Cancel"), this);
  cancelButton->setGeometry(200, 210, 100, 25);
  connect( cancelButton, SIGNAL(clicked()), SLOT(reject()) );

  nameLabel = new QLabel(i18n("Configuration name:"), this);
  nameLabel->move(10, 10);
  nameLabel->setAutoResize(true);

  nameEdit = new QLineEdit(this);
  nameEdit->setGeometry(180, 10, 120, 25);

  osLabel = new QLabel(i18n("Operating system:"), this);
  osLabel->move(10, 50);
  osLabel->setAutoResize(true);

  osComboBox = new QComboBox(false, this);
  osComboBox->setGeometry(180, 50, 120, 25);
  osComboBox->insertItem(i18n("Linux"));
  osComboBox->insertItem(i18n("Other os"));
  connect(osComboBox, SIGNAL(activated(int)), this, SLOT(osChange()) );

  partitionLabel = new QLabel(i18n("(Root-) Partition to boot:"), this);
  partitionLabel->move(10, 90);
  partitionLabel->setAutoResize(true);

  partitionEdit = new QLineEdit(this);
  partitionEdit->setGeometry(180, 90, 120, 25);

  kernelLabel = new QLabel(i18n("Kernel to boot:"), this);
  kernelLabel->move(10, 130);
  kernelLabel->setAutoResize(true);

  kernelEdit = new QLineEdit(this);
  kernelEdit->setGeometry(180, 130, 120, 25);

//  appendLabel = new QLabel(this);
//  appendLabel->setGeometry(10,170,10,25);
//  appendLabel->setAutoResize(true);
//  appendLabel->setText(i18n("Append:"));

//  appendEdit = new QLineEdit(this);
//  appendEdit->setGeometry(180,170,120,25);

  setFixedSize(310, 240);

  if (addMode == true)
    caption = i18n("Add: ");
  else
    caption = i18n("Edit: ");

  nameChanged(nameEdit->text());
  connect(nameEdit, SIGNAL(textChanged(const char*)), this, SLOT(nameChanged(const char*)));
}

void ConfigEditDialog::setConfig( OSProperties *osEntry )
{
 nameEdit->setText(osEntry->label);
 if (!osEntry->isLinux)
   osComboBox->setCurrentItem(1);
 partitionEdit->setText(osEntry->positionOnDisk);
 kernelEdit->setText(osEntry->kernel);

 osChange();
}

void ConfigEditDialog::osChange()
{
 if (osComboBox->currentItem() == 0)
   {
    kernelLabel->setEnabled(true);
    kernelEdit->setEnabled(true);
//    appendLabel->setEnabled(true);
//    appendEdit->setEnabled(true);
   }
 else
   {
    kernelLabel->setEnabled(false);
    kernelEdit->setEnabled(false);
//    appendLabel->setEnabled(false);
//    appendEdit->setEnabled(false);
   }
}

QString ConfigEditDialog::getLabel()
{
 QString value = nameEdit->text();
 return value;
}

bool ConfigEditDialog::isLinux()
{
 if (osComboBox->currentItem() == 0)
   return true;
 else
   return false;
}

QString ConfigEditDialog::getPartition()
{
 QString value = partitionEdit->text();
 return value;
}

QString ConfigEditDialog::getKernel()
{
 QString value = kernelEdit->text();
 return value;
}

void ConfigEditDialog::nameChanged(const char *text)
{
 QString tmp;

 tmp.sprintf("%s%s", caption.data(), text);
 setCaption(tmp);
}