/***************************************************************************
                          toplevel.cpp  -  description
                             -------------------
    begin                : Sat May 15 13:31:44 MEST 1999

    copyright            : (C) 1999 by Andreas Heck
    email                : aheck@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "toplevel.h"


TopLevel::TopLevel()
  : KTMainWindow()
{

QPixmap aboutklilo;
//aboutklilo.load("klilologo.gif");
KIconLoader icon;
aboutklilo = icon.loadIcon("klilologo.gif");

// Begin of osGroupBox

 osGroupBox = new QGroupBox(this);
 osGroupBox->setGeometry(10,10,250,170);
 osGroupBox->setTitle(i18n("Operating systems:"));

 listBox = new QListBox(osGroupBox);
 listBox->setGeometry(10,20,165,100);
 connect(listBox, SIGNAL(selected(int)), this, SLOT(editEntry()));
 connect(listBox, SIGNAL(highlighted(int)), this, SLOT(listItemSelected()));

 addButton = new QPushButton(osGroupBox);
 addButton->setGeometry(180,20,60,30);
 addButton->setText(i18n("Add"));
 connect(addButton, SIGNAL(clicked()), this, SLOT(addEntry()));

 editButton = new QPushButton(osGroupBox);
 editButton->setGeometry(180,55,60,30);
 editButton->setText(i18n("Edit"));
 editButton->setEnabled(false);
 connect(editButton, SIGNAL(clicked()), this, SLOT(editEntry()));

 deleteButton = new QPushButton(osGroupBox);
 deleteButton->setGeometry(180,90,60,30);
 deleteButton->setText(i18n("Delete"));
 deleteButton->setEnabled(false);
 connect(deleteButton, SIGNAL(clicked()), this, SLOT(deleteEntry()));

 defaultOSLabel = new QLabel(osGroupBox);
 defaultOSLabel->setGeometry(10,130,70,25);
 defaultOSLabel->setAutoResize(true);
 defaultOSLabel->setText(i18n("Default OS:"));

 defaultOSCombo = new QComboBox(FALSE, osGroupBox);
 defaultOSCombo->setGeometry(90,130,150,25);

 connect(defaultOSCombo, SIGNAL(activated(const char*)), this, SLOT(defaultOSChanged(const char*)));

// end of osGroupBox

// Begin of GeneralGroupBox

 generalGroupBox = new QGroupBox(this);
 generalGroupBox->setGeometry(280,10,200,170);
 generalGroupBox->setTitle(i18n("General Options"));

 linearBox = new QCheckBox(generalGroupBox);
 linearBox->setGeometry(10,20,0,0);
 linearBox->setAutoResize(true);
 linearBox->setText(i18n("linear option"));

 extendedBox = new QCheckBox(generalGroupBox);
 extendedBox->setGeometry(10,50,0,0);
 extendedBox->setAutoResize(true);
 extendedBox->setText(i18n("extended VGA option"));

 timeLabel = new QLabel(generalGroupBox);
 timeLabel->setGeometry(10,105,10,25);
 timeLabel->setAutoResize(true);
 timeLabel->setText(i18n("Boot delay:"));

 timeEdit = new QLineEdit(generalGroupBox);
 timeEdit->setGeometry(80,100,40,25);

 secLabel = new QLabel(generalGroupBox);
 secLabel->setGeometry(125,105,10,25);
 secLabel->setAutoResize(true);
 secLabel->setText(i18n("sec"));

// End of GeneralGroupBox

// Begin of InstallGroupBox

 InstallGroupBox = new QGroupBox(this);
 InstallGroupBox->setGeometry(10,190,360,65);
 InstallGroupBox->setTitle(i18n("Install LInux LOader"));

 installLabel = new QLabel(InstallGroupBox);
 installLabel->setGeometry(10,20,10,25);
 installLabel->setAutoResize(true);
 installLabel->setText(i18n("Install Bootmanager to:"));

 installCombo = new QComboBox(FALSE, InstallGroupBox);
 installCombo->setGeometry(170,20,180,25);
 installCombo->insertItem(i18n("Master Boot Record"));
 installCombo->insertItem(i18n("Root Partition"));
 installCombo->insertItem(i18n("Floppy"));

// End of InstallGroupBox

// Begin normal Buttons on QWidget

 installButton = new QPushButton(this);
 installButton->setGeometry(270,265,100,25);
 installButton->setText(i18n("Install"));
 connect(installButton, SIGNAL(clicked()), this, SLOT(installConfig()));

 quitButton = new QPushButton(this);
 quitButton->setGeometry(160,265,100,25);
 quitButton->setText(i18n("Quit"));
 connect(quitButton, SIGNAL(clicked()), kapp, SLOT(quit()));

 aboutButton = new KButton(this);
 aboutButton->setGeometry(380,195,100,95);
 aboutButton->setPixmap( aboutklilo );
 connect(aboutButton, SIGNAL(clicked()), this, SLOT(aboutApp()));

 helpButton = new QPushButton(this);
 helpButton->setGeometry(10,265,100,25);
 helpButton->setText(i18n("Help"));
 connect(helpButton, SIGNAL(clicked()), this, SLOT(invokeHelp()));


//End of component declarations

 liloconfig = new LiloConfig;
 readConfig();

 defaultOS = listBox->text(0);

 updateDefaultOSCombo();

 setCaption(APP_NAME);
 setFixedSize(490,300);
}

// Begin of functions

void TopLevel::closeEvent( QCloseEvent * )
{
 kapp->quit();
}

void TopLevel::aboutApp()
{
 QString tmp, tmp2;
 tmp.sprintf(i18n("About %s"), APP_NAME);
 tmp2.sprintf(i18n("%s %s\n\n(C) 1999 Andreas Heck (aheck@gmx.de)\n\nIdea and Programming:\nAndreas Heck\n\nGraphical User Interface:\nMichael Flaig(mflaig@pro-linux.de)\n\nThis Software is distributed under the GNU General Public License"), APP_NAME, VERSION);
 QMessageBox::about(this, tmp, tmp2);
}

void TopLevel::invokeHelp()
{
 kapp->invokeHTMLHelp("klilo/index.html", "");
}

void TopLevel::readConfig()
{
 liloconfigdata = liloconfig->readConfig();
 linearBox->setChecked(liloconfigdata.linear);
 if (liloconfigdata.vga =="ext")
   extendedBox->setChecked(true);
 if (liloconfigdata.bootPartition != NULL)
   {
    if ((liloconfigdata.bootPartition == "/dev/hda") || (liloconfigdata.bootPartition == "/dev/sda"))
      installCombo->setCurrentItem(0);
    else
      if (liloconfigdata.bootPartition == "/dev/fd0")
        installCombo->setCurrentItem(2);
      else
        installCombo->setCurrentItem(1);
   }
  QString bootDelay = NULL;
  bootDelay.sprintf("%d", liloconfigdata.bootDelay/10);
  timeEdit->setText(bootDelay);
  OSProperties *item;
  for ( item = liloconfigdata.osList.first(); item != 0; item = liloconfigdata.osList.next() )
      listBox->insertItem( liloconfigdata.osList.current()->label );
}

void TopLevel::addEntry()
{
   ConfigEditDialog dialog(this, "", true);
   if ( dialog.exec() )
     {
      if ( dialog.getLabel().simplifyWhiteSpace() != "" )
        {
         liloconfigdata.osList.append( new OSProperties() );
         OSProperties *listItem = liloconfigdata.osList.current();
         listItem->label = dialog.getLabel();
         listItem->isLinux = dialog.isLinux();
         listItem->positionOnDisk = dialog.getPartition();
         listItem->kernel = dialog.getKernel();
         listBox->insertItem( listItem->label.data(), listBox->count() );
         updateDefaultOSCombo();
        }
     }
}

void TopLevel::editEntry()
{
 if ( listBox->currentItem() != -1 )
  {
   OSProperties *listItem = liloconfigdata.osList.at(listBox->currentItem());
   ConfigEditDialog dialog;
   dialog.setConfig( listItem );
   if ( dialog.exec() )
     {
      listItem->label = dialog.getLabel();
      listItem->isLinux = dialog.isLinux();
      listItem->positionOnDisk = dialog.getPartition();
      listItem->kernel = dialog.getKernel();
      listBox->changeItem( listItem->label.data(), listBox->currentItem());
      updateDefaultOSCombo();
     }
  }
}

void TopLevel::deleteEntry()
{
  QString question;
  question.sprintf("Do you really want to delete the entry \"%s\"?", listBox->text(listBox->currentItem()));
  if (QMessageBox::information(this, i18n("KLILO"),
    question, i18n("Yes"), i18n("No"), 0) == 0)
     {
      if (listBox->currentItem() != -1)
        {
          liloconfigdata.osList.remove( listBox->currentItem() );
          listBox->removeItem( listBox->currentItem() );
          updateDefaultOSCombo();
        }
     }
}

void TopLevel::updateGlobalOptions()
{
 switch (installCombo->currentItem())
 {
   case 0:
   liloconfigdata.bootPartition = liloconfig->getMBR();
   break;

   case 1:
   liloconfigdata.bootPartition = liloconfig->getRootPartition();
   break;

   case 2:
   liloconfigdata.bootPartition = "/dev/fd0";
   break;
 }


 liloconfigdata.linear = linearBox->isChecked();
 if (extendedBox->isChecked())
   liloconfigdata.vga = "ext";
 else
   liloconfigdata.vga = "normal";
 liloconfigdata.bootDelay = atoi(timeEdit->text())*10;

 if (defaultOS != listBox->text(0))
   {
     int count = listBox->count();
     int i;
     for (i = 0; i < count; i++)
       {
        if (listBox->text(i) == defaultOS)
          break;
       }
     OSProperties buffer = *(liloconfigdata.osList.at(0));
     *(liloconfigdata.osList.at(0)) = *(liloconfigdata.osList.at(i));
     *(liloconfigdata.osList.at(i)) = buffer;

     QString listbuffer = listBox->text(0);
     listBox->changeItem(listBox->text(i),0);
     listBox->changeItem(listbuffer, i);

     updateDefaultOSCombo();
   }
}

void TopLevel::installConfig()
{
 OutputDialog dialog;

 updateGlobalOptions();
 liloconfig->writeConfig(&liloconfigdata);
 dialog.exec();
}

void TopLevel::listItemSelected()
{
 editButton->setEnabled(true);
 deleteButton->setEnabled(true);
 disconnect(listBox, SIGNAL(highlighted(int)), this, SLOT(listItemSelected()));
}

void TopLevel::updateDefaultOSCombo()
{
 int count, i;

 defaultOSCombo->clear();

 count = listBox->count();
 for (i = 0; i < count; i++)
   {
    defaultOSCombo->insertItem(listBox->text(i));
    QString text = listBox->text(i);
    if (text.lower() == defaultOS.lower())
      defaultOSCombo->setCurrentItem(i);
   }
}

void TopLevel::defaultOSChanged(const char *string)
{
 defaultOS = string;
}
