/***************************************************************************
                          toplevel.h  -  description
                             -------------------
    begin                : Sat May 15 13:31:44 MEST 1999

    copyright            : (C) 1999 by Andreas Heck
    email                : aheck@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _TOPLEVEL_H_
#define _TOPLEVEL_H_

#include <kapp.h>
#include <ktmainwindow.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qmessagebox.h>
#include <iostream.h>
#include <qstring.h>
#include <qpixmap.h>
#include <kbutton.h>
#include <kiconloader.h>

#include "liloconfig.h"
#include "configeditdialog.h"
#include "outputdialog.h"
#include "global.h"

class TopLevel : public KTMainWindow
{
  Q_OBJECT
  
public:

  TopLevel();

protected:

  void closeEvent( QCloseEvent *e );

private slots:

  void aboutApp();
  void invokeHelp();
  void installConfig();

  void addEntry();
  void editEntry();
  void deleteEntry();

  void listItemSelected();

  void defaultOSChanged(const char*);

private:

  void readConfig();
  void updateGlobalOptions();
  void updateDefaultOSCombo();


  QString defaultOS;
  QLabel *installLabel, *secLabel, *timeLabel, *defaultOSLabel;
  QCheckBox *linearBox, *extendedBox;
  QComboBox *installCombo, *defaultOSCombo;
  QLineEdit *timeEdit;
  QListBox *listBox;
  QPixmap *aboutklilo;
  KButton *aboutButton;
  QGroupBox *generalGroupBox, *osGroupBox, *InstallGroupBox;
  QPushButton *editButton, *addButton, *deleteButton, 
              *quitButton, *helpButton, *installButton;
  LiloConfig *liloconfig;
  LiloConfigData liloconfigdata;

};

#endif