/***************************************************************************
    $Id: printcap.cpp,v 1.2 1999/09/21 16:29:18 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: printcap.cpp,v $
    Revision 1.2  1999/09/21 16:29:18  wdl
    Fixed binary character in printcap file

    Revision 1.1  1999/09/14 00:26:27  wdl
    Restructuring of directories

    Revision 1.6  1999/09/12 10:28:12  stephan
    Bugfixes and some changes for the shared lib

    Revision 1.5  1999/08/27 16:43:02  wdl
    Standard Headers

 ***************************************************************************/
#include "printcap.h"

printcap::printcap(const char *fileName){
	//parse(fileName); this method is not really needed..... but perhaps it will be usefull later.....
	// but watch out....there are still lots of bugs in the parse method...
}

printcap::~printcap(){
}

void printcap::write(printcapEntry *entry){
	if(PrinterEntries.contains(entry) == 0) PrinterEntries.append(new printcapEntry(*entry));
}

printcapEntry * printcap::read(int num){
	return PrinterEntries.at(num);
}

int printcap::remove(const char *name){
	printcapEntry *tmpEntry;
	QString *tmpStr = new QString;
	QList<QString> *tmpLst = new QList<QString>;
	int rval;
	rval = 1;
	for(tmpEntry = PrinterEntries.first(); tmpEntry != 0; tmpEntry = PrinterEntries.next()) {
		*tmpLst = tmpEntry->getAliasList();
		for(tmpStr = tmpLst->first(); tmpStr != 0; tmpStr = tmpLst->next()){
			if(*tmpStr == name) PrinterEntries.remove();
			rval = 0;			
		}
  }
	delete(tmpEntry);
	delete(tmpLst);
	delete(tmpStr);
	if (rval == 0) return 0;
	return -1;
}

// internal methods!!!
bool printcap::parse(const char *fileName){
  QFile printcapFD(fileName);
	QTextStream *printcapStream = new QTextStream( &printcapFD );
	QString *tmpStr,*entryStr,*tmpStr0;
	QList<QString> *entryList;
	tmpStr = new QString;
	entryStr = new QString;
	entryList = new QList<QString>;
  tmpStr0 = new QString;
	if(!printcapFD.open(IO_ReadWrite)) {printf("\nKpclib(printcap::parse()) File %s not found\n",fileName); return false;}
	// First Stage Parsing
	while(!printcapStream->eof()) {
	 *tmpStr = printcapStream->readLine();
 		if(tmpStr->find("#") == 0) {}
		else if(tmpStr->isEmpty()) {}
		else {
			*entryStr = *tmpStr;
			*entryStr = entryStr->replace(QRegExp(":\\"),"");
			do {
				*tmpStr = printcapStream->readLine();
				*tmpStr0 = *tmpStr;
				tmpStr0->remove(0,1);
				*entryStr = *entryStr + tmpStr0->replace(QRegExp(":\\"),"");
			} while(tmpStr->contains("\\")!=0);
			entryList->append(new QString(entryStr->data()));
			delete(entryStr);
			entryStr = new QString;
		}
  }	
	printcapFD.close();
	// -- give some mem free...has no use anymore
	delete(printcapStream);	
  // Second Stage Parsing
	QList<QString> *subEntryList = new QList<QString>;
	for(tmpStr = entryList->first(); tmpStr != 0; tmpStr = entryList->next()) {
   	printcapEntry *tmpPrinterEntry = new printcapEntry();
	  QString *tagPair = new QString;
		QString *tag = new QString;
	 	QString *value = new QString;
	 	bool firstLine;
	 	firstLine = true;
	 	QList<QString> *tagPairLst = new QList<QString>;
 	delete(entryStr);
	 for(*tagPair = strtok(tmpStr->data(),":"); *tagPair != NULL; *tagPair = strtok(NULL,":")){
			tagPairLst->append(new QString(*tagPair));
		}
		printf("\nda2!!!\n");
		for(tagPair = tagPairLst->first(); tagPair != 0; tagPair = tagPairLst->next()) {
			if(firstLine == true) {tmpPrinterEntry->setSpoolName(tagPair->data()); firstLine = false;}
  		if(tagPair->contains("=") != 0) {
				*tag = strtok(tagPair->data(),"=");
				*value = strtok(NULL,"=");
				if(tag->contains("lp") == 1){ tmpPrinterEntry->setPrinterPort(value->data()); }
				if(tag->contains("sd") == 1) { tmpPrinterEntry->setSpoolDir(value->data()); }
				if(tag->contains("lf") == 1) { tmpPrinterEntry->setLogFile(value->data()); }
        if(tag->contains("af") == 1) { tmpPrinterEntry->setAccountFile(value->data()); }
				if(tag->contains("if") == 1) { tmpPrinterEntry->setFilterName(value->data()); }
				if(tag->contains("lf") == 1) { tmpPrinterEntry->setLogFile(value->data()); }
				if(tag->contains("rm") == 1) { tmpPrinterEntry->setRemoteMachine(value->data()); }
				if(tag->contains("rp") == 1) { tmpPrinterEntry->setRemotePrinterName(value->data()); }
			}
		}
	 PrinterEntries.append(new printcapEntry(*tmpPrinterEntry));
	 delete(tagPairLst);
	 delete(value);
	 delete(tagPair);
	 delete(tmpPrinterEntry);	
		
	}
	// final mem cleanup
	printf("\ndada3!!!\n");
	delete(subEntryList);
	delete(entryList);
  delete(entryStr);
	delete(tmpStr);	
	//delete(tag);
	printf("\ndammit!!!\n");
	return true;
}

bool printcap::sync(const char *fileName){
	QFile pcFD(fileName);
	printcapEntry *tmpEntry;
	if(!pcFD.open(IO_WriteOnly)){printf("\nKpclib(printcap::sync()) Error while opening %s \n",fileName); return false; }
	QTextStream printcapStream( &pcFD );
	printcapStream << "##### Entries generated by KPC" << endl;
	printcapStream << "##### please don't edit this file by hand." << endl;
	printcapStream << "# APS_BASEDIR:" << kapp->kde_datadir() << "/kpcwizard/filter" << endl;
	for(tmpEntry = PrinterEntries.first(); tmpEntry != 0; tmpEntry = PrinterEntries.next()){
			if(tmpEntry->isSpoolName()) printcapStream << tmpEntry->getSpoolName() << ":\\" << endl; // spool name line
			if(tmpEntry->isPrinterPort()) printcapStream << "\t:lp=" << tmpEntry->getPrinterPort() << ":\\" << endl;
			if(tmpEntry->isSpoolDir()) printcapStream << "\t:sd=" << tmpEntry->getSpoolDir() << ":\\" << endl; // spool dir
      if(tmpEntry->isLogFile()) printcapStream << "\t:lf=" << tmpEntry->getLogFile() << ":\\" << endl; // log file
			if(tmpEntry->isAccountFile()) printcapStream << "\t:af=" << tmpEntry->getAccountFile() << ":\\" << endl; // account file
			if(tmpEntry->isFilterName()) printcapStream << "\t:if=" << tmpEntry->getFilterName() << ":\\" << endl; // filter
			if(tmpEntry->isRemoteMachine()) printcapStream << "\t:rm=" << tmpEntry->getRemoteMachine() << ":\\" << endl; // remote machine
			if(tmpEntry->isRemotePrinterName()) printcapStream << "\t:rp=" << tmpEntry->getRemotePrinterName() << ":\\" << endl; // rem. printer qu.
			printcapStream << "\t:la@:mx#0:\\" << endl;
			printcapStream << "\t:sh:sf:" << endl;
	}			
	pcFD.close();
	delete(tmpEntry);
	return true;
}

































