/***************************************************************************
    $Id: printcapentry.h,v 1.1 1999/09/14 00:26:28 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: printcapentry.h,v $
    Revision 1.1  1999/09/14 00:26:28  wdl
    Restructuring of directories

    Revision 1.3  1999/08/27 16:43:03  wdl
    Standard Headers

 ***************************************************************************/
#ifndef PRINTCAPENTRY_H
#define PRINTCAPENTRY_H

#include <iostream.h>
#include <qstring.h>
#include <qlist.h>

/**
  *@author Stephan Heigl
  */

class printcapEntry {
public: 
	//printcapEntry(const char *name,const char *spooldir,const char *filtername,const char *logfile,const char *account);
	printcapEntry(printcapEntry & pc_to_cp);
	printcapEntry();
	~printcapEntry();
	void setSpoolName(const char *val){ SpoolName = val; updateAlias();}
	void setSpoolDir(const char *val) { SpoolDir = val; }
	void setFilterName(const char *val) { FilterName = val; }
	void setLogFile(const char *val) { LogFile = val; }
	void setAccountFile(const char *val) { AccountFile = val; }
	void setPrinterPort(const char *val) { PrinterPort = val; }
	void setRemoteMachine(const char *val) { RemoteMachine = val; }
	void setRemotePrinterName(const char *val) { RemotePrinterName = val; }
	void setOthers(const char *val) { Others = val; }

	const char * getSpoolName() {return SpoolName.data(); }
	const char * getSpoolDir() { return SpoolDir.data(); }
	const char * getFilterName() { return FilterName.data(); }
	const char * getLogFile() { return LogFile.data(); }
	const char * getAccountFile() { return AccountFile.data(); }
	const char * getPrinterPort() { return PrinterPort.data(); }
	const char * getRemoteMachine() { return RemoteMachine.data(); }
	const char * getRemotePrinterName() { return RemotePrinterName.data(); }
	const char * getOthers() { return Others.data(); }

	bool isDefaultQueue();
	bool isSpoolName();
	bool isSpoolDir();
	bool isFilterName();
	bool isLogFile();
	bool isAccountFile();
	bool isPrinterPort();
	bool isRemoteMachine();
	bool isRemotePrinterName();
	bool isOthers();

	void setDefaultQueue(bool flag);
	bool isNetworkPrinter();

	QList<QString> getAliasList() { return SpoolNameAlias;}
	void addAlias(const char *val) { SpoolNameAlias.append(new QString(val)); updateSpoolName(); }
	void rmAlias(const char *val) { SpoolNameAlias.remove(new QString(val)); updateSpoolName(); }

private:
	QList <QString> SpoolNameAlias;
	QString SpoolName;
	QString SpoolDir;
	QString FilterName;
	QString LogFile;
	QString AccountFile;
	QString PrinterPort;
	QString RemotePrinterName;
	QString RemoteMachine;
	QString Others;
	void updateAlias();
	void updateSpoolName();
};

#endif










