/***************************************************************************
    $Id: smbfilter.h,v 1.1 1999/09/14 00:26:29 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: smbfilter.h,v $
    Revision 1.1  1999/09/14 00:26:29  wdl
    Restructuring of directories

    Revision 1.1  1999/09/12 10:26:54  stephan
    Added a filter handler for smb hosts

    Revision 1.2  1999/08/27 16:21:21  wdl
    Standard Headers

 ***************************************************************************/
#ifndef SMBFILTER_H
#define SMBFILTER_H

#include <qstring.h>
#include <qlist.h>
#include <iostream.h>
#include <qfile.h>
#include <qtextstream.h>

#include "apsfilter.h"

class SMBfilter {
	public:
		SMBfilter(apsfilter &,const char *_s_machine,const char *_s_service,const char *_user=0,const char *_pwd=0);
		~SMBfilter();
    const char *getFilterName();
		void setup();
		static bool check();
    static QList<QString> browse(const char *host,const char *ip=0);
	private:
		QString ServiceMachine;
		QString Service;
		QString User;
		QString Password;

		QString Filterpath,apsfilterName;
};

#endif




