/***************************************************************************
    $Id: finishpage.cpp,v 1.4 1999/09/23 16:06:30 stephan Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: finishpage.cpp,v $
    Revision 1.4  1999/09/23 16:06:30  stephan
    Minor changes in kpcwizard

    Revision 1.3  1999/09/18 15:45:12  stephan
    Minor changes.

    Revision 1.2  1999/08/27 16:42:55  wdl
    Standard Headers

 ***************************************************************************/

#include "finishpage.h"

FinishPage::FinishPage(QWidget *parent, const char *name ) : QWidget(parent,name) {
	Help = new HTMLHelp(this);
	Help->setGeometry(0,0,150,height());
	Help->showHelp("finish.html");
	Lab_man = new QLabel(this);
  Lab_model = new QLabel(this);
  Lab_paper = new QLabel(this);
	Lab_port = new QLabel(this); Lab_port->hide();
	Lab_machine = new QLabel(this); Lab_machine->show();
	Lab_spool = new QLabel(this); Lab_spool->show();
	
	defPrinter = new QCheckBox(i18n("Should become default printer"),this);
	defPrinter->setGeometry(160,250,200,25);
	defPrinter->setChecked(false);
}
FinishPage::~FinishPage(){
}

void FinishPage::setPrinter(KpcPrinter _prt){
	Lab_man->setText(i18n("Manufactor: ") + *(new QString(_prt.getManufactor())));
	Lab_man->setGeometry(160,40,200,25);

	Lab_model->setText(i18n("Model: ") + *(new QString(_prt.getModel())));
	Lab_model->setGeometry(160,65,200,25);

	Lab_paper->setText(i18n("Paper Format: ") + *(new QString(_prt.getPaperFormat())));
	Lab_paper->setGeometry(160,90,200,25);

	if( _prt.getNetworkType() == KpcPrinter::local ) {
		Lab_machine->hide();
		Lab_spool->hide();
		Lab_port->show();
		Lab_port->setText(i18n("Port: ") + *(new QString(_prt.getPort())));
		Lab_port->setGeometry(160,115,200,25);
	} else
	if( _prt.getNetworkType() == KpcPrinter::lpd ) {
		Lab_port->hide();
		Lab_machine->show();
		Lab_spool->show();
		Lab_machine->setText(i18n("Remote Machine: ") + *(new QString(_prt.getRemoteMachine())));
		Lab_machine->setGeometry(160,115,200,25);
		Lab_spool->setText(i18n("Remote Spool: ") + *(new QString(_prt.getRemoteQueue())));
		Lab_spool->setGeometry(160,140,200,25);
	} else
	if( _prt.getNetworkType() == KpcPrinter::smb ) {
		Lab_port->hide();
		Lab_machine->show();
		Lab_spool->show();
		Lab_machine->setText(i18n("Machine: ") + *(new QString(_prt.getRemoteMachine())));
		Lab_machine->setGeometry(160,115,200,25);
		Lab_spool->setText(i18n("Service: ") + *(new QString(_prt.getRemoteQueue())));
		Lab_spool->setGeometry(160,140,200,25);
	}

}

void FinishPage::resizeEvent(QResizeEvent *){
	Help->setGeometry(0,10,150,height()-20);	
}



