/***************************************************************************
    $Id: modelpage.h,v 1.4 1999/08/27 16:42:57 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: modelpage.h,v $
    Revision 1.4  1999/08/27 16:42:57  wdl
    Standard Headers

 ***************************************************************************/
#ifndef MODELPAGE_H
#define MODELPAGE_H

#include <kapp.h>
#include <qwidget.h>
#include <ktreelist.h>
#include <qstring.h>
#include <qlabel.h>
#include <qlist.h>
#include <qpixmap.h>

#include "kpcapi.h"
#include "htmlhelp.h"
//#include "printerdb.h"
//#include "printerdbentry.h"

/**
  *@author Stephan Heigl
  */

class ModelPage : public QWidget {
	Q_OBJECT
public:
	ModelPage(QWidget *parent=0, const char *name=0);
	~ModelPage();

	const char * getModelName() { return ModelName.data(); }
	const char * getManufactor() { return Manufactor.data(); }
	bool isDataComplete() { return DataComplete; }
	void readPrinterDB();
public slots:
	void lookItemUp(int num);
protected:
	void resizeEvent(QResizeEvent *);
private:
	HTMLHelp *Help;
	KTreeList *ModelLst;
	QString ModelName;
	QString Manufactor;
	QLabel *ModelLab,*ManuLab;
	bool DataComplete;
};

#endif












