/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include "isapnpdb.h"
#include "isapnpdevice.h"
#include "isapnpvendors.h"

extern ISAPnPDataBase          isapnpdb;
extern ISAPnPVendorDictionary  isapnpvendors;


ISAPnPDevice::ISAPnPDevice(QString vendorid, uint devid, QString devname,
			   uint logid, QString logname) : _vendorid(vendorid),
			   				  _devicename(devname),
					                  _logname(logname),
					                  _deviceid(devid),
							  _logid(logid),
							  _active(false)
{
  lookupData();
}


/*
 * Public methods
 *****************/

int  ISAPnPDevice::settingsBasedOn()
{
  ResourceBaseConfig  *baseconf;
  
  for (baseconf = _conflist.first(); baseconf; baseconf = _conflist.next())
  {debug("Checking base configuration %i...", _conflist.at());
    if (baseconf->contains(_reslist)) return _conflist.at();
  }  
  return -1;
}


QString  ISAPnPDevice::deviceClassName()
{
  switch (_class)
  {
    case ISAPnPClassNetworkOther    : return QString("Network controller");
    case ISAPnPClassMultimediaAudio : return QString("Multimedia audio controller");   	   
    case ISAPnPClassInputOther	    : return QString("Input device controller");
    default	                    : return QString("Unknown device");
  }
}


Device::devstate  ISAPnPDevice::deviceState()
{
  Resource  *res;

  /*
   * If the device requires I/O addresses, I guess there must be
   * a range of 2 bytes at least; so if range > 1 that indicates
   * those I/O addresse were found in /proc/ioports and thus the
   * driver for this device must have registered them, that is,
   * the driver is present - otherwise we don't know.
   ***************************************************************/
  
  for (res = firstResource(); res; res = nextResource())
    if ((res->resourceType() == Resource::ResIOAddress) && (res->resourceRange() > 1)) 
      return DeviceStateReady;
    
  return DeviceStateUnknown;
}


/*
 * Private methods
 ******************/

void  ISAPnPDevice::lookupData()
{
  ISAPnPDeviceInfo  *info;
  
  _vendorname = isapnpvendors[_vendorid.data()];

  if ((info = isapnpdb.find(_vendorid, _deviceid, _logid)))
  {
    _baseclass = info->baseClass();
    _class     = info->isapnpClass();
  }
}
