/***************************************************************************
    kuninstalllistview.cpp  -  description                              
    -------------------                                         
    begin                : Tue Mar 16 1999                                           
    copyright            : (C) 1999 by Geri House                         
    email                : ge_ha@yahoo.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <kapp.h>
#include <kpopmenu.h>

#include "kuninstalllistview.h"

KUninstallListView::KUninstallListView( QWidget * parent, const char * name)
:QListView(parent, name) {
	lastSize=0;
	lastNumber=0;
    setAllColumnsShowFocus(TRUE);
}

KUninstallListView::~KUninstallListView(){
}

void KUninstallListView::mousePressEvent ( QMouseEvent * m) {
    KUninstallListItem *item=(KUninstallListItem*)itemAt(m->pos());
	if (m->button() == LeftButton) {
    	if (item!=0) {
    	    setSelected(item,TRUE);
    		if (item->depth()>1) {
				int width=treeStepSize()*item->depth()+20;
				if (m->x() < width || m->x() > width+18) {
			    	bool setOpen = FALSE ;
					if (item->isOn()==FALSE)
        				setOpen=TRUE;
        			checkItemAndChilds(item, setOpen);
        			emit changeChecked(item);
        		}
        	}
        }
    }
    else if (m->button() == RightButton)  {
    	if (childCount()!=0) {
			KPopupMenu * menue= new KPopupMenu(i18n("Operations"),0, "Operations");
			if (item!=0) {
    	    	setSelected(item,TRUE);
				if (item->isOpen()==FALSE)
					menue->insertItem(i18n("Expand"),this, SLOT(expandOrCollapse()));
				else	
					menue->insertItem(i18n("Collapse"),this, SLOT(expandOrCollapse()));	
				if (item->isOn()==TRUE)
					menue->insertItem(i18n("Uncheck Item"),this, SLOT(checkOne()));
				else	
					menue->insertItem(i18n("Check Item"),this, SLOT(checkOne()));
				menue->insertSeparator();
				if (item->type()== QCheckListItem::Controller && item->depth()==0) {
					menue->insertItem(i18n("Check Application"),this, SLOT(checkApp()));
					menue->insertItem(i18n("Uncheck Application"),this, SLOT(uncheckApp()));
					menue->insertSeparator();
				}
			}	
			else
				setSelected(currentItem(),FALSE);
			menue->insertItem(i18n("Uncheck All"),this, SLOT(uncheckall()));
			menue->insertItem(i18n("Check All"),this, SLOT(checkall()));
			menue->move(m->globalPos());
			menue->show();
		}
    }
    else
    	QListView::mousePressEvent(m);
}


void KUninstallListView::mouseDoubleClickEvent(QMouseEvent * m) {
	KUninstallListItem *item=(KUninstallListItem *)currentItem();
    if (item!=0)
    	item->showChildItems();
    QListView::mouseDoubleClickEvent(m);
}

void KUninstallListView::checkItemAndChilds(KUninstallListItem *item, bool setOpen) {
     lastSize=item->getSizeAndNumber(lastNumber);
     item->setOn(setOpen);
     item->checkAllChilds(setOpen);
     item->repaint();  	
     KUninstallListItem *parent=(KUninstallListItem *)item->parent();
     while(parent!=0) {
       	if (setOpen==TRUE) {
        	if (parent->isOn()==FALSE)
          		parent->setOn(setOpen);
          	}   	
        	parent->repaint();	
        	parent=(KUninstallListItem *)parent->parent();	
        }	
}

void KUninstallListView::checkOne() {
	KUninstallListItem *item=(KUninstallListItem *)currentItem();
	if (item!=0)
		checkItemAndChilds(item,!item->isOn());
    emit changeChecked(item);
}

void KUninstallListView::checkApp() {
	KUninstallListItem *item=(KUninstallListItem *)currentItem();
	if (item!=0 && item->type()== QCheckListItem::Controller)
		checkItemAndChilds(item,TRUE);
    emit changeChecked(item);
}

void KUninstallListView::uncheckApp() {
	KUninstallListItem *item=(KUninstallListItem *)currentItem();
	if (item!=0 && item->type()== QCheckListItem::Controller)
		checkItemAndChilds(item,FALSE);
    emit changeChecked(item);
}

void KUninstallListView::expandOrCollapse() {
	KUninstallListItem *item=(KUninstallListItem *)currentItem();
	if (item!=0)
    	item->showChildItems();
    if (item->isOpen()==FALSE)
    	item->setOpen(TRUE);
    else		
    	item->setOpen(FALSE);
}

void KUninstallListView::uncheckall() {
	KUninstallListItem *parent=(KUninstallListItem*)firstChild();	
    for (int i=0;i<childCount();i++) {
        KUninstallListItem *first=(KUninstallListItem*)parent->firstChild();
		do
		{
			first->setOn(FALSE);
			first->checkAllChilds(FALSE);
			first->repaint();
			first=(KUninstallListItem*)first->nextSibling();
		} while (first!=NULL);
	    parent=(KUninstallListItem*)parent->nextSibling();	
	}
    emit emitUpdateNumLabel(0);
    emit emitUpdateSizeLabel(0);
}

void KUninstallListView::checkall() {
    int numberItems=0;
    float sumSize=0;
    int number=0;
	KUninstallListItem *parent=(KUninstallListItem*)firstChild();	
    for (int i=0;i<childCount();i++) {
        KUninstallListItem *first=(KUninstallListItem*)parent->firstChild();
		do
		{
			first->setOn(TRUE);
			first->checkAllChilds(TRUE);
			first->repaint();
    		sumSize+= first->getSizeAndNumber(number);
	    	numberItems+=number;
			first=(KUninstallListItem*)first->nextSibling();
		} while (first!=NULL);
	    parent=(KUninstallListItem*)parent->nextSibling();	
	}
    emit emitUpdateNumLabel(numberItems);
    emit emitUpdateSizeLabel(sumSize);
}











































































