/***************************************************************************
                          dpms.cpp  -  description                              
                             -------------------                                         

    version              :                                   
    begin                : Fri Feb 5 1999                                           
    copyright            : (C) 1999 by Didier Gaudin                         
    email                : gaudin@club-internet?fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <klocale.h>
#include "dpms.h"
#include <qpixmap.h>
#include <qframe.h>
#include <kconfig.h>
#include <kiconloader.h>

Dpms::Dpms(QWidget *parent, const char *name) : QWidget(parent, name)
{
 KIconLoader IL;
 modified= FALSE;
 QLabel * LabelPixmap = new QLabel(this);
 LabelPixmap->setPixmap(IL.loadIcon("dpms.xpm"));
 LabelPixmap->setGeometry(50,10,80,60);

 QFrame *tmp = new QFrame(this);
 tmp->setFrameStyle( QFrame::HLine | QFrame::Sunken );
 tmp->setLineWidth( 2 );
 tmp->setGeometry(10,75,410,2);

 ChkDpms =  new QCheckBox(klocale->translate("Enable DPMS"),this);
 ChkDpms -> setGeometry(10,90,200,20);
 connect(ChkDpms,SIGNAL(toggled (bool)),SLOT(slotdpmsActive(bool)));

 LabelStandby = new QLabel(this);
 LabelStandby -> setText(klocale->translate("Standby Time:"));
 LabelStandby -> setGeometry(80,150,100,20);
 LabelStandby -> setAlignment(AlignRight);
 LabelStandby -> setEnabled(FALSE);

 SpinStandby = new QSpinBox(this);
 SpinStandby -> setGeometry(190,150,50,20);
 SpinStandby -> setEnabled (FALSE);

 LabelStaMin = new QLabel(this);
 LabelStaMin -> setText("Minutes");
 LabelStaMin -> setGeometry(250,150,70,20);
 LabelStaMin -> setEnabled(FALSE);

 LabelSuspend = new QLabel(this);
 LabelSuspend ->  setText(klocale->translate("Suspend Time"));
 LabelSuspend -> setGeometry(80,180,100,20);
 LabelSuspend -> setAlignment(AlignRight);
 LabelSuspend ->  setEnabled(FALSE);

 SpinSuspend = new QSpinBox (this);
 SpinSuspend -> setGeometry(190,180,50,20);
 SpinSuspend -> setEnabled (FALSE);

 LabelSusMin = new QLabel (this);
 LabelSusMin -> setText("Minutes");
 LabelSusMin -> setGeometry(250,180,70,20);
 LabelSusMin -> setEnabled(FALSE);

 LabelOff = new QLabel(this);
 LabelOff -> setText("Off Time:");
 LabelOff -> setGeometry(80,210,100,20);
 LabelOff -> setAlignment(AlignRight);
 LabelOff ->  setEnabled(FALSE);

 SpinOff = new QSpinBox (this);
 SpinOff -> setGeometry(190,210,50,20);
 SpinOff -> setEnabled (FALSE);

 LabelOffMin = new QLabel(this);
 LabelOffMin -> setText("Minutes");
 LabelOffMin -> setGeometry(250,210,70,20);
 LabelOffMin -> setEnabled(FALSE);

/*mise a jours des champs*/
 KConfig * fichier = new KConfig(NULL,"xfreeconfig");
 fichier->setGroup("Energy");
 ChkDpms->setChecked(fichier->readBoolEntry("Dpms",FALSE) );
 SpinOff -> setValue (fichier->readNumEntry("Off",15) );
 SpinSuspend -> setValue (fichier->readNumEntry("Suspend",10) );
 SpinStandby -> setValue(fichier->readNumEntry("Standby", 5) );
 modified=TRUE;
 connect(SpinOff, SIGNAL(valueChanged(int)), SLOT(slotvaluechanged(int)));
 connect(SpinSuspend, SIGNAL(valueChanged(int)), SLOT(slotvaluechanged(int)));
 connect(SpinStandby, SIGNAL(valueChanged(int)), SLOT(slotvaluechanged(int)));

}

void Dpms::slotvaluechanged(int a)
{
  modified = TRUE;
}

Dpms::~Dpms(){
}

void Dpms::slotdpmsActive(bool valeur)
{
  SpinOff      -> setEnabled(valeur ? TRUE : FALSE);
  LabelOff     -> setEnabled(valeur ? TRUE : FALSE);
  SpinSuspend  -> setEnabled(valeur ? TRUE : FALSE);
  LabelSuspend -> setEnabled(valeur ? TRUE : FALSE);
  SpinStandby  -> setEnabled(valeur ? TRUE : FALSE);
  LabelStandby -> setEnabled(valeur ? TRUE : FALSE);
  LabelStandby -> setEnabled(valeur ? TRUE : FALSE);
  LabelOffMin  -> setEnabled(valeur ? TRUE : FALSE);
  LabelSusMin  -> setEnabled(valeur ? TRUE : FALSE);
  LabelStaMin  -> setEnabled(valeur ? TRUE : FALSE);
  modified=TRUE;
}


void Dpms::writeconfig()
{
 if(modified == TRUE)
 {
  KConfig * fichier = new KConfig(NULL,"xfreeconfig");
  fichier->setGroup("Energy");
  fichier->writeEntry("Dpms",ChkDpms->isChecked());
  fichier->writeEntry("Standby",SpinStandby->text());
  fichier->writeEntry("Suspend",SpinSuspend->text());
  fichier->writeEntry("Off",SpinOff->text());
  fichier->sync();
  delete fichier;
  modified = FALSE;
 }
}









