/***************************************************************************
                          dhlogdoc.h  -  description                              
                             -------------------                                         
    begin                : Tue Jun 22 17:36:34 MEST 1999
                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef DHLOGDOC_H
#define DHLOGDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include "dhlog.h"
#include "logbook.h"
// forward declaration of the DHLog classes
class DHLogView;

/**	DHLogDoc provides a document object for a document-view model.
  *
	* The DHLogDoc class provides a document object that can be used in conjunction with the classes DHLogApp and DHLogView
	* to create a document-view model for standard KDE applications based on KApplication and KTMainWindow. Thereby, the document object
	* is created by the DHLogApp instance and contains the document structure with the according methods for manipulation of the document
	* data by DHLogView objects. Also, DHLogDoc contains the methods for serialization of the document data from and to files.
	*
	* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
	* @version KDevelop version 0.4 code generation
	*/
class DHLogDoc : public QObject
{
  Q_OBJECT

 public:
  /** Constructor for the fileclass of the application */
  DHLogDoc(QWidget* parent, const char *name=0);
  /** Destructor for the fileclass of the application */
  ~DHLogDoc();
	/** adds a view to the document which represents the document contents. Usually this is your main view. */
  void addView(DHLogView* m_pView);
	/** removes a view from the list of currently connected views */
	void removeView(DHLogView* m_pView);
  /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
  void setModified(bool modified=true){ b_modified=modified; }
	/** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
  bool isModified(){ return b_modified;}
	/** "save modified" - asks the user for saving if the document is modified */
	bool saveModified();	
	/** deletes the document's contents */
	void deleteContents();
	/** initializes the document generally */
	bool newDocument();
	/** closes the acutal document */
	void closeDocument();
	/** loads the document by filename and format and emits the updateViews() signal */
  bool openDocument(const char* filename, const char* format=0);
  /** saves the document under filename and format.*/	
  bool saveDocument(const char* filename, const char* format=0);
	/** sets the path to the file connected with the document */
	void pathName(const char* path_name);
	/** returns the pathname of the current document file*/
	const QString& getPathName() const;
	/** sets the filename of the document */
	void title(const char* title);
	/** returns the title of the document */
	const QString& getTitle() const;

	void setConfig(KConfig* aconfig);
		
	void sortLog();
	void editDeleteQso();
	void editBeginning();
	void editEnding();
	void editPrev();
	void editNext();
	void editJump();
	void editQso();
	void editCall();
	
	void loggingNew();
	void loggingOnTime();
	
	void qslIn();
	void qslOut();
	void qslSetOut();
	
 public slots:
 	/** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
 	  * As this view normally repaints itself, it is excluded from the paintEvent. */
 	void slotUpdateAllViews(DHLogView* pSender);
 	
 public:	
 	/** the list of the views currently connected to the document */
	static QList<DHLogView>* viewList;	
	LogBook *log;
 private:
 	/** the modified flag of the current document */
 	bool b_modified;
	QString m_title;
	QString m_path;
	KConfig *config;
	

};

#endif // DHLOGDOC_H






























