/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [config.cpp]                Configuration Dialog                           */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

#include "config.h"
#include <qwidget.h>
#include <ktabctl.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qlayout.h>
#include <qgrpbox.h>
#include <qchkbox.h>

#include <qcombo.h>
#include <qlined.h>

#include <stdio.h>
#include <stdlib.h>

#include "config.moc"

//FIXME: `STDC_HEADERS nessesary?
// #define STDC_HEADERS
#include <kconfig.h>

static KConfig* cf;
static QString  cf_name;

#define HERE printf("%s(%d): here.\n",__FILE__,__LINE__)

//why isn't there a macro?
#define MAX(a,b) ((a)>(b)?(a):(b))

enum tLine { GROUP, SELECT, TEXT, CHECK };

static struct cLine
{ tLine kind;
  char* title;
  char* dft;     // if not GROUP
  char* values;  // in case of SELECT
} config[]
=
{
  { GROUP,  "BBS",                NULL,          NULL                },
  { TEXT,   CONF_BBS_NAME,        "",            NULL                },
  { TEXT,   CONF_DIAL_PHONE,      "",            NULL                },
  { SELECT, CONF_EMULATION,       "0",        
                                  "ansi\n"
                                  "vt100\n"
                                  "tty\n"                            },
  { SELECT, CONF_LOGIN_PROTOCOL,  "3",
                                  "Use Custom autologin\n"     
                                  "Autologin disabled\n"
                                  "No autologin and IEMSI\n"
                                  "Esc,IEMSI\n"
                                  "Esc,Name,Password\n"
                                  "Esc,Name,Yes,Password\n"
                                  "Name,Password\n"
                                  "Name,Yes,Password\n"              },
  { TEXT,   CONF_CUSTOM_LOGIN,    "",            NULL                },

  { GROUP,  "Identity",           NULL,          NULL                },
  { TEXT,   CONF_ID_USERNAME,     "",            NULL                },
  { TEXT,   CONF_ID_PASSWORD,     "",            NULL                },
  { TEXT,   CONF_ID_ALIAS,        "",            NULL                },
  { TEXT,   CONF_ID_LOCATION,     "",            NULL                },
  { TEXT,   CONF_ID_VOICE_NR,     "",            NULL                },
  { TEXT,   CONF_ID_DATA_NR,      "",            NULL                },

  { GROUP,  "Serial",             NULL,         NULL                 },
  { SELECT, CONF_DEVICE,          "1",          "none\nmodem\n"
                                                "ttyS0\nttyS1\n"
                                                "ttyS2\nttyS3\n"
                                                "ttyI0\nttyI1\n"
                                                "ptys2\n"     },
  { SELECT, CONF_SPEED,           "6",          "300\n600\n1200\n"
                                                "2400\n4800\n"
                                                "19200\n38400\n"
                                                "57600\n115200\n"    },
  { SELECT, CONF_PARITY,          "0",          "None\nEven\nOdd\n"  },
  { SELECT, CONF_DATABITS,        "4",          "4\n5\n6\n7\n8\n"    },
  { SELECT, CONF_STOPBITS,        "0",          "1\n2\n"             },
  { SELECT, CONF_HANDSHAKE,       "1",          "None\nHardware\n"
                                                "Software\nBoth\n"   },

  { GROUP,  "Modem",              NULL,          NULL                },
  { TEXT,   CONF_INIT_STRING,     "ATZ^M",       NULL                },
  { TEXT,   CONF_DIAL_PREFIX,     "ATDT",        NULL                },
  { TEXT,   CONF_DIAL_SUFFIX,     "^M",          NULL                },

  { GROUP,  "General",            NULL,          NULL                },
  { TEXT,   CONF_DOWNLOAD_DIR,    "/tmp",        NULL                },
  { TEXT,   CONF_LOGO,            "Kom.ans",     NULL                },
  { TEXT,   CONF_CAPTURE_FILE,    "",            NULL                },
  { CHECK,  "CheckTest"      ,    "0",           NULL                },

  { GROUP,  "Local",              NULL,          NULL                },
  { TEXT,   CONF_LOCAL_YES,       LCL_YES,       NULL                },
  { TEXT,   CONF_DATE_FORMAT,     LCL_DATE,      NULL                },
  { TEXT,   CONF_TIME_FORMAT,     LCL_TIME,      NULL                }
};

#define cLines (sizeof(config)/sizeof(cLine))

#define LWIDTH 10
#define RWIDTH 15

void Config::makePages(KTabCtl* tc)
{ QWidget* w0; QBoxLayout* l0; 
  QGroupBox* f0; QGridLayout* xx=NULL;
  QBoxLayout* g0; QPushButton* d0;
  QComboBox* cb; QLineEdit* le; QCheckBox* chk;
  int i,j,cnt,lin,glen; int grp=0; char* p; char* q;

  // calculate max grid len
  for (grps = 0, cnt = 0, glen = 0, i = 0; i < cLines; i++,cnt++)
  if (config[i].kind == GROUP)
  { glen = MAX(glen,cnt-1); cnt = 0; grps += 1; }
  glen = MAX(glen,cnt-1);
  layouts = (QLayout**)malloc(sizeof(QLayout*)*grps*2);
  for (i = 0; i < cLines; i++)
  switch (config[i].kind)
  {
    case GROUP  :
         w0 = new QWidget(tc);
         l0 = new QBoxLayout(w0,QBoxLayout::TopToBottom,5);
         layouts[2*grp+0] = l0;
         f0 = new QGroupBox("",w0);
         for (cnt = 0, j = i+1; j < cLines; j++, cnt++)
           if (config[j].kind == GROUP) break;
         // fill other elements (up to max len) with spaces.
         xx = new QGridLayout(f0,glen,2,20,5);
         layouts[2*grp+1] = xx;
         for (j = cnt; j < glen; j++)
         {
           xx->addWidget(new QWidget(f0),j,0);
           xx->addWidget(new QWidget(f0),j,1);
         }
         xx->setColStretch(0,LWIDTH);
         xx->setColStretch(1,RWIDTH);
         xx->activate();
         l0->addWidget(f0,5);
         g0 = new QBoxLayout(QBoxLayout::LeftToRight,5);
         l0->addLayout(g0,0);
         g0->addStretch();
         d0 = new QPushButton("&Defaults",w0);
         d0->adjustSize();
         d0->setFixedSize( d0->size() );
         QToolTip::add(d0,"Reset this page to standard values");
         QObject::connect(d0,SIGNAL(clicked()),this,SLOT(setSectionDefault()));
         g0->addWidget(d0,0,AlignRight);
         g0->addStrut(d0->height());
         l0->activate();
         tc->addTab(w0,config[i].title);
         lin = 0;
         cf->setGroup(config[i].title);
         grp += 1;
         break;
    case SELECT :
         cb = addcombo(f0,xx,lin++,config[i].title);
         for (p = config[i].values, q=p; *p; p++) if (*p == '\n')
         { char buf[100]; 
           strncpy(buf,q,p-q); buf[p-q]=0; q=p+1;
           cb->insertItem(buf);
         }
         cb->setCurrentItem(atoi(cf->readEntry(config[i].title)));
         widgets[i] = cb;
         break;
    case TEXT   : 
         le = addtextf(f0,xx,lin++,config[i].title, 40);
         le->setText(cf->readEntry(config[i].title));
         widgets[i] = le;
         break;
    case CHECK  : 
         chk = addcheck(f0,xx,lin++,config[i].title, 40);
         chk->setText(cf->readEntry(config[i].title));
         widgets[i] = chk;
         break;
  }
}

QComboBox* Config::addcombo(QWidget* p, QGridLayout* lay, int row, char* label)
{ char buffer[1000]; 
  sprintf(buffer,"%s . . . . . . . . . . . . . . . . . . . . . . . ",label);
  QLabel* lbl = new QLabel(buffer,p); lbl->setPalette(pal);
  QComboBox* res = new QComboBox(FALSE,p);
  lay->addWidget(lbl,row,0);
  lay->addWidget(res,row,1);
  return res;
}

QLineEdit* Config::addtextf(QWidget* p, QGridLayout* lay, int row, char* label, int len)
{ char buffer[1000]; 
  sprintf(buffer,"%s . . . . . . . . . . . . . . . . . . . . . . . ",label);
  QLabel* lbl = new QLabel(buffer,p); lbl->setPalette(pal);
  QLineEdit* res = new QLineEdit(p); res->sizeHint(); // res->setMaxLength(len);
  lay->addWidget(lbl,row,0);
  lay->addWidget(res,row,1);
  return res;
}

QCheckBox* Config::addcheck(QWidget* p, QGridLayout* lay, int row, char* label, int len)
{ char buffer[1000]; 
  sprintf(buffer,"%s . . . . . . . . . . . . . . . . . . . . . . . ",label);
  QLabel* lbl = new QLabel(buffer,p); lbl->setPalette(pal);
  QCheckBox* res = new QCheckBox(p); res->sizeHint(); // res->setMaxLength(len);
  lay->addWidget(lbl,row,0);
  lay->addWidget(res,row,1);
  return res;
}

Config::Config( QWidget *parent=0, const char *name=0 )
    : QWidget( parent, name )
{ KTabCtl* tc;
  QPushButton* ok;
  QPushButton* ca;
  QPushButton* sa;
  QBoxLayout*  l2;
  // blue labels
  QColorGroup coln = this->palette().normal();
  QColorGroup x(coln.foreground(), coln.background(),
                coln.light(), coln.dark(), coln.mid(), 
                blue/*coln.text()*/, coln.base());
  pal = QPalette(x,x,x);

  widgets = (QWidget**)malloc(sizeof(QWidget*)*cLines);

  // make tab widget
  l1 = new QBoxLayout(this, QBoxLayout::TopToBottom , 5);

  tc = new KTabCtl(this); makePages(tc);
  l1->addWidget(tc,1000);

  ok = new QPushButton("&Ok",this);
  sa = new QPushButton("&Save",this);
  ca = new QPushButton("&Cancel",this);
  ca->adjustSize();
  ca->setFixedSize( ca->size() );
  ok->setFixedSize( ca->size() );
  sa->setFixedSize( ca->size() );
  QToolTip::add(ok,"Accept changes and close window");
  QToolTip::add(ca,"Discard changes and close window");
  QToolTip::add(sa,"Accept changes and leave window open");

  l2 = new QBoxLayout( QBoxLayout::LeftToRight, 5 );
  l1->addLayout(l2);
  l2->addStretch();
  l2->addWidget(ok,0,AlignRight);
  l2->addWidget(ca,0,AlignRight);
  l2->addWidget(sa,0,AlignRight);
  l2->addStrut(ok->height());
  l1->activate();

  QObject::connect( ca, SIGNAL(clicked()), this, SLOT(quit()) );
  QObject::connect( ok, SIGNAL(clicked()), this, SLOT(done()) );
  QObject::connect( sa, SIGNAL(clicked()), this, SLOT(save()) );
  QObject::connect( tc, SIGNAL(tabSelected(int)), this,SLOT(tabSelected(int)) );
  
setFixedSize(350,300);
//setMinimumSize(300,350);

  ctabPage = 0;
  show();
}

void Config::quit()
{
  close();
}

void Config::done()
{
  save();
  close();
}

void Config::tabSelected(int page)
{
  ctabPage = page;
}

Config::~Config()
{ int i;
  for (i = 0; i<2*grps; i++) delete layouts[i];
  delete l1;
  free(layouts);
  free(widgets);
}

void Config::closeEvent(QCloseEvent* e)
{
  delete this;
}

void Config::setSectionDefault()
{ int i; int grp = -1;
  for (i = 0; i < cLines; i++)
  switch(config[i].kind)
  {
    case GROUP  : grp += 1;
                  break;
    case TEXT   : if (grp == ctabPage)
                  ((QLineEdit*)widgets[i])->setText(config[i].dft);
                  break;
    case SELECT : if (grp == ctabPage)
                  ((QComboBox*)widgets[i])->setCurrentItem(atoi(config[i].dft));
                  break;
  }
}

void Config::save()
{ int i;
  for (i = 0; i < cLines; i++)
  switch(config[i].kind)
  {
    case GROUP  : cf->setGroup(config[i].title);
                  break;
    case TEXT   : cf->writeEntry(config[i].title,
                                 ((QLineEdit*)widgets[i])->text() );
                  break;
    case SELECT : cf->writeEntry(config[i].title,
                                 ((QComboBox*)widgets[i])->currentItem() );
                  break;
  }
//FIXME: check config is writeable
  cf->sync();
}

void config_init(char* rc)
// make sure config is properly set.
{ int i;
  cf_name = rc;
//QFile* pConfigFile = new QFile( cf_name );
//pConfigFile->open( IO_ReadWrite ); 
//QTextStream* pConfigStream = new QTextStream( pConfigFile );
//cf = new KConfig( pConfigStream );
  cf = new KConfig( rc );
  for (i = 0; i < cLines; i++)
  switch(config[i].kind)
  {
    case GROUP  : cf->setGroup(config[i].title);
                  break;
    case TEXT   : 
    case SELECT : if (!cf->hasKey(config[i].title))
                    cf->writeEntry(config[i].title,config[i].dft);
                  break;
  }
//FIXME: check config is writeable
  cf->sync();
}

const char* config_get(const char* key)
{ int i; char* cgrp;
  for (i = 0; i<cLines; i++)
    if (config[i].kind == GROUP) cgrp = config[i].title; else
    if (!strcmp(config[i].title,key))
    {
      cf->setGroup(cgrp);
      return cf->readEntry(key).data();
    }
  return "[key not found]";
}

char* conv_controls(const char* key)
// convert (short) string containing ^Char
{ int i; static char buf[100];
  for (i=0;*key;key++)
  if (*key == '^' && key[1])
    buf[i++] = (*++key)-'@';
  else
    buf[i++] = *key;
  buf[i] = 0;
  return buf;
}

static char* devices[] =
{
  "none",
  "/dev/modem",
  "/dev/ttyS0",
  "/dev/ttyS1",
  "/dev/ttyS2",
  "/dev/ttyS3",
  "/dev/ttyI0",
  "/dev/ttyI1",
  "/dev/ptys2"
};

const char* conv_devices(const char* num)
{
fprintf(stderr,"device no = %s\n",num);
  return devices[atoi(num)];
}
