/*
    File: led.cpp
    Version: 0.2.1
    Date: 1998/14/01
    Copyright: Bernhard Kuhn <kuhn@lpr.e-technik.tu-muenchen.de>

    This file defines an Led, which can be turned on or off :-)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/



#include "led.h"



// constructor (default: led=off)

led::led(QWidget* parent=0,char* name="",bool initstate=false,
  QColor setColor=LED_STD_SET,QColor clrColor=LED_STD_CLR)
  : QFrame(parent,name),ledOn(initstate),
    setColor(setColor),clrColor(clrColor) {
  
  // Apperance
  setFrameStyle(WinPanel|Sunken);

  // select brush for future drawing
  ledBrush=QBrush((ledOn)?setColor:clrColor);
 
};




// set led state

void led::setLed(bool newstate=true) {

  if(newstate != ledOn) {

    // store new value
    ledOn=newstate;

    // select brush for future drawing
    ledBrush=QBrush((ledOn)?setColor:clrColor);
    
    repaint(false);

  };

};



// draw led content

void led::drawContents(QPainter* p) {

  // no comment
  p->fillRect(contentsRect(),ledBrush); 
};
