/*
    File: ringbuffer.h
    Version: 0.2.1
    Date: 1998/14/01
    Copyright: Bernhard Kuhn <kuhn@lpr.e-technik.tu-muenchen.de>

    Here, we have a very simple ringbuffer-class!

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/



#include "ringbuffer.h"



// constructor

Ringbuffer::Ringbuffer(int size,bool clear=true) : size(size),run(0) {
  buffer = new float[size];
  if(clear) for(int i=0;i<size;i++) buffer[i]=0;
};



// destructor

Ringbuffer::~Ringbuffer() {
  delete buffer;
};



// store new value

void Ringbuffer::push(float value) {
  buffer[run]=value;
  if(++run==size) run=0;
};



// get an item from the buffer.
// positiv values go back in time

float Ringbuffer::get(int item=0) {
  if(item>=size) return 0;
  int pos=run-item;
  if(pos<0) pos+=size;
  return buffer[pos];
};
