/***************************************************************************
                          dokvokview.h  -  description
                             -------------------
    begin                : Son Dez 19 13:14:00 CET 1999
    copyright            : (C) 1999 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DOKVOKVIEW_H
#define DOKVOKVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>
#include <qpalette.h>
#include <qlistview.h>


//include my files
#include "../vtyplist.h"
#include "vvoklist.h"

#include <stdio.h>

class DokVokDoc;

/** The DokVokView class provides the view widget for the DokVokApp instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As DokVokView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the DokVokApp class to manipulate and display
 * the document structure provided by the DokVokDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class DokVokView : public QWidget
{
  Q_OBJECT
  public:
    /** Constructor for the main view */
    DokVokView(QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~DokVokView();

    /** returns a pointer to the document connected to the view instance. Mind that this method requires a DokVokApp instance as a parent
     * widget to get to the window document pointer by calling the DokVokApp::getDocument() method.
     *
     * @see DokVokApp#getDocument
     */
    DokVokDoc *getDocument() const;

		/** */
		virtual void resizeEvent( QResizeEvent *ResizeEvent ) { VokList.resize( width(), height() ); }

    /** contains the implementation for printing functionality */
    void print(QPrinter *pPrinter);
	  /** appends new vokabel */
	  void appendVokabel ( VVokabel *Vokabel, bool UpdateView = true );
	  /** clears the VokList */
	  void clearVokList() { VokList.clear(); }
    /** returns the Editmode */
    const bool &isEditMode() { return VokList.isEditMode(); };
    
    /** returns the currentl vok */
    VVokabel *currentVok();
    /** returns the first seleted vok */
    VVokabel *firstSelectedVok();
    /** returns the next selected vok */
    VVokabel *nextSelectedVok();
    /** if there is marked text in the EditField it will be returned */
//    QString selectedText();
    /** returns true if items are selected */
    bool hasSelectedItems();;
    
    /** inserts text in the editfield */
    void insertText() { VokList.insertText(); }
    /** cuts text in the editfield */
    void cutText() { VokList.cutText(); }
    /** copies text in the editfield */
    void copyText() { VokList.copyText(); }
    /** selects all */
    void selectAll();
    /** deselects all */
    void deselectAll();
    /** inverts Selection */
    void invertSelection();
    
    VTypInfoList *typInfoList() { return &TypInfoList; }
	
  private:
	  /** */
		VVokList VokList;
	  /** */
		VTypInfoList TypInfoList;
		/** a palette where active looks like normal BUT SEEMS TO HAVE NO EFFECT :( */
		QPalette EditingPalette;
	
	protected slots: // Protected slots
	  /** tells the Doc to append new Vokabel to list */
	  void askForNewVokabel();
	  /** sets modified */
	  void setModified();
	public slots: // Public slots
	  /** sets the titel of a column */
	  void setColumnTitel( int Column, const char *Titel ) { VokList.setColumnText( Column, Titel ); }
	  /** sets the titel of a column */
	  void setLanguage( int Column, const char *Titel );
	  /** sets the EditMode */
	  void setEditMode ( bool Editing = true ); 
	  /**  */
	  void setPasteFromClipboard ( bool Switch ) { emit clipboardHasData( Switch ); }
	  
	signals:
	  /** */
	  void clipboardHasData( bool );
	  /** */
	  void newTypInfoList( VTypInfoList * );
};

#endif // DOKVOKVIEW_H
