/////////////////////////////////////////////////////////////////////////////
//
// A QGroupBox like box with title, optional a checkbox and a peer window 
// inside
//
/////////////////////////////////////////////////////////////////////////////

// taken from kppp

#include "EAGroupBox.h"
#include <qlabel.h>

#define BORDER_X 6
#define BORDER_Y 6

EAGroupBoxBase::EAGroupBoxBase(QWidget *parent, const char *name) :
  QFrame(parent, name),
  _title(0)
{
  setFrameStyle(Box | Sunken);
  _peer = new QWidget(this);
}

QSize EAGroupBoxBase::minimumSize() const {
  return QSize(0, 0);
}


QSize EAGroupBoxBase::maximumSize() const {
  return QSize(1 << 15, 1 << 15);
}


QSize EAGroupBoxBase::sizeHint() const {
  return minimumSize();
}


void EAGroupBoxBase::resizeEvent(QResizeEvent *) {
  initBox();
}

void EAGroupBoxBase::initBox() {
  QRect peergeo;

  frect = QRect(BORDER_X, BORDER_Y, 
		width() - 2*BORDER_X, height() - 2*BORDER_Y);
  peergeo = QRect(frect.left() + 6,
		  frect.top() + 6,
		  frect.width() - 12 - 1,
		  frect.height() - 12 - 1);

  // adjust frame to fit title
  if(_title != 0) {
    frect.setTop(frect.top() + _title->minimumSize().height()/2);
    peergeo.setTop(peergeo.top() + _title->minimumSize().height());
    _title->resize(_title->minimumSize().width() + 8,
		   _title->minimumSize().height());
    _title->move(peergeo.left() + 6,
		 frect.top() - _title->minimumSize().height()/2);
  }

  setFrameRect(frect);
  _peer->setGeometry(peergeo);
}


void EAGroupBoxBase::setTitleWidget(QWidget *title) {
  if(_title)
    delete _title;
  
  _title = title;
  initBox();  
}


EAGroupBox::EAGroupBox(const char *title, QWidget *parent, const char *name) :
  EAGroupBoxBase(parent, name)
{
  setTitle(title);
}


void EAGroupBox::setTitle(EA_QTSTR name) {
  QLabel *l = new QLabel(name, this);
  l->setMinimumSize(l->sizeHint());
  l->setAlignment(AlignCenter);
  setTitleWidget(l);
}


EACheckGroupBox::EACheckGroupBox(const char *title, QWidget *parent, const char *name) :
  EAGroupBoxBase(parent, name)
{
  setTitle(title);
}

void EACheckGroupBox::setTitle(EA_QTSTR name) {
  printf ("ct eacgb\n");
  cbox = new QCheckBox(name, this);
  cbox->setMinimumSize(cbox->sizeHint());
  connect(cbox, SIGNAL(toggled(bool)),
	  this, SLOT(slot_toggled(bool)));
  setTitleWidget(cbox);  
}


void EACheckGroupBox::slot_toggled(bool b) {
  emit toggled(b);
}


void EACheckGroupBox::setChecked(bool b) {
  cbox->setChecked(b);
}


bool EACheckGroupBox::isChecked() {
  return cbox->isChecked();
}


EARadioGroupBox::EARadioGroupBox(const char *title, QWidget *parent, const char *name) :
  EAGroupBoxBase(parent, name)
{
  setTitle(title);
}


void EARadioGroupBox::setTitle(EA_QTSTR name) {
  rb = new QRadioButton(name, this);
  rb->setMinimumSize(rb->sizeHint());
  connect(rb, SIGNAL(toggled(bool)),
	  this, SLOT(slot_toggled(bool)));
  setTitleWidget(rb);
}


void EARadioGroupBox::slot_toggled(bool b) {
  emit toggled(b);
}


bool EARadioGroupBox::isChecked() {
  return rb->isChecked();
}


