/***************************************************************************
                 EntryDlg.h  -  entry dialog for table cell contents
                             -------------------                                         
    begin                : Thu Mar 11 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef _EntryDlg_CONJUGATION
#define _EntryDlg_CONJUGATION i18n("Con&jugation")
#endif

#ifndef _EntryDlg_ADJECTIVE
#define _EntryDlg_ADJECTIVE i18n("Compar&ison")
#endif

#ifdef __ONLY_TO_BE_SEEN_BY_XGETTEXT
  _EntryDlg_CONJUGATION
  _EntryDlg_ADJECTIVE
#else

#ifndef EntryDlg_included
#define EntryDlg_included

#include <qtabdialog.h>
#include "FromToEntryPage.h"
#include "CommonEntryPage.h"
#include "AuxInfoEntryPage.h"
#include "TenseEntryPage.h"
#include "AdjEntryPage.h"
#include "kvoctraindoc.h"

class LangSet;

class EntryDlg : public QTabDialog
{
    Q_OBJECT

public:

    EntryDlg
    (
        kvoctrainDoc *doc,
        bool        multi_sel,
        bool        origin,
        grade_t     f_grd,
        grade_t     t_grd,
        count_t     f_qcount,
        count_t     t_qcount,
        count_t     f_bcount,
        count_t     t_bcount,
        time_t      f_qdate,
        time_t      t_qdate,
        QString     f_faux_ami,
        QString     t_faux_ami,
        QString     _expr,
        int         _lesson,
        QComboBox  *_lessonBox,
        QString     lang,
        LangSet    &langset,
        QString     remark,
        QString     _type,
        QString     pronunce,
        QString     synonym,
        QString     antonym,
        QString     example,
        const       Conjugation &con_prefix,
        const       Conjugation &conjugations,
        const       Article &article,
        const       Comparison &comp,
        QWidget    *parent = NULL,
        const char *name = NULL
    );

    bool  fromDateDirty   () const { return from_page ? from_page->dateDirty() : false; }
    bool  fromGradeDirty  () const { return from_page ? from_page->gradeDirty() : false; }
    bool  fromBCountDirty () const { return from_page ? from_page->bCountDirty() : false; }
    bool  fromQCountDirty () const { return from_page ? from_page->qCountDirty() : false; }
    QString getFromFauxAmi  () const { return from_page ? from_page->getFauxAmi() : QString(""); }

    time_t  getFromDate   () const { return from_page ? from_page->getDate() : 0; }
    grade_t getFromGrade  () const { return from_page ? from_page->getGrade() : KV_NORM_GRADE; }
    count_t getFromBCount () const { return from_page ? from_page->getBCount() : 0; }
    count_t getFromQCount () const { return from_page ? from_page->getQCount() : 0; }

    bool  toDateDirty     () const { return to_page ? to_page->dateDirty() : false; }
    bool  toGradeDirty    () const { return to_page ? to_page->gradeDirty() : false; }
    bool  toBCountDirty   () const { return to_page ? to_page->bCountDirty() : false; }
    bool  toQCountDirty   () const { return to_page ? to_page->qCountDirty() : false; }
    QString getToFauxAmi  () const { return to_page ? to_page->getFauxAmi() : QString(""); }

    time_t  getToDate     () const { return to_page ? to_page->getDate() : 0; }
    grade_t getToGrade    () const { return to_page ? to_page->getGrade() : KV_NORM_GRADE; }
    count_t getToBCount   () const { return to_page ? to_page->getBCount() : 0; }
    count_t getToQCount   () const { return to_page ? to_page->getQCount() : 0; }

    bool    lessonDirty  () const { return comm_page->lessonDirty(); }
    bool    typeDirty    () const { return comm_page->typeDirty  (); }

    int     getLesson   () const { return comm_page->getLesson(); }
    QString getType     () const { return comm_page->getType(); }
    QString getExpr     () const { return comm_page->getExpr(); }
    QString getRemark   () const { return comm_page->getRemark(); }
    QString getPronunce () const { return comm_page->getPronunce(); }
    QString getExample  () const { return comm_page->getExample(); }

    QString getSynonym  () const { return aux_page->getSynonym(); }
    QString getAntonym  () const { return aux_page->getAntonym(); }

    Conjugation getConjugation() const { return tense_page->getConjugation(); }

    Comparison getComparison() const { return adj_page->getComparison(); }

    virtual ~EntryDlg();

protected slots:

//  virtual void appHelpActivated();

protected slots:
    void updatePages(const QString &type);

protected:

    FromToEntryPage  *from_page,
                     *to_page;
    CommonEntryPage  *comm_page;
    AuxInfoEntryPage *aux_page;
    TenseEntryPage   *tense_page;
    AdjEntryPage     *adj_page;
};


#endif // EntryDlg_included

#endif // __ONLY_TO_BE_SEEN_BY_XGETTEXT
