
// http://dict.leo.org/cgi-bin/dict/dict-search.pl?search=indispensable&header=on&links=hide&mirrors=on

#include "online.h"
#include "compat_2x.h"

#include <ksock.h>
#include <qstring.h>
#include <qtimer.h>
#include <qapplication.h>
#include <stdio.h>
#include <iostream.h>
#include <unistd.h>


#ifdef __STAND_ALONE

#define VERSION "0.2"

main (int argc, char** argv) {
  QApplication app (argc, argv);
  LEO_Dictionary dict ("localhost", 80);
  dict.sendQuery ("hallo");
  while (dict.isConnected() ) {
    qApp->processEvents();
    qApp->flushX();
  }
  if (!dict.timedOut() )
    cout << dict.getMessage() << endl;
  else
    cout << "timeout\n";
  cout << "fertig\n";
}

#endif

OnlineDictionary::OnlineDictionary (QString servername, int portnum)
{
    server = servername;
    port = portnum;
    sock = 0;
    timeout = new QTimer (this);
    connect( timeout, SIGNAL(timeout()), this, SLOT(slotTimeout()) );
}


void OnlineDictionary::initSocket ()
{
  if (!sock) {
    cout << "is: " << server << " " << port << endl;
    mesg = "";
    tout = false;
    sock = new KSocket (server, port, 2);
    cout << sock->socket() << endl;
//  connect (sock, SIGNAL (writeEvent(KSocket*)), this, SLOT (writeEvent(KSocket*)) );
    connect (sock, SIGNAL (readEvent(KSocket*)),  this, SLOT (readEvent(KSocket*)) );
    connect (sock, SIGNAL (closeEvent(KSocket*)), this, SLOT (closeEvent(KSocket*)) );
    sock->enableRead (true);
//  sock->enableWrite (true);
  }
}


bool OnlineDictionary::sendQueryUrl (QString url)
{
    initSocket();
    cout << "squ: " << url << endl;
    mesg = "";
    tout = false;
    QString   request;
    request = "GET ";
    request += url;
    request += " HTTP/" KV_HTTP_LEVEL "\n";
    request += "Accept: text/html";
    request += "User-Agent: kvoctrain/" VERSION;
    request += "\n\n";
    bool res = write (sock->socket(), request, request.length ()) > 0;
    timeout->start(timeoutVal()*1000, true);
    sleep(2);
    return res;
}

void OnlineDictionary::closeConnection ()
{
    delete sock;
    sock = 0;
}


OnlineDictionary::~OnlineDictionary()
{
   closeConnection();
}


void OnlineDictionary::writeEvent(KSocket *sock)
{
  cout << "wev\n";
}


void OnlineDictionary::readEvent(KSocket *sock)
{
  timeout->stop();
  char buf[256];
  cout << "rev\n";
  ssize_t n;
  while ((n = read (sock->socket(), buf, 1) > 0 )) {
    buf[n] = '\0';
    mesg += buf;
//  write (1, buf, n);
  }
  if (n > 0)
    timeout->start(timeoutVal()*1000, true);
}


void OnlineDictionary::closeEvent(KSocket *sock)
{
  cout << "cev\n";
  closeConnection();
  parseContent();
}


void OnlineDictionary::parseContent()
{
}


void OnlineDictionary::slotTimeout()
{
  cout << "timeout\n";
  tout = true;
}


QString OnlineDictionary::getMessage () const
{
   return mesg;
}


LEO_Dictionary::LEO_Dictionary (QString servername, int portnum)
  : OnlineDictionary (servername, portnum)
{
}


vector<QString> LEO_Dictionary::getResults ()
{
  return vector<QString>();
}


bool LEO_Dictionary::sendQuery (QString expr)
{
  cout << "sq\n";
  QString url;
//  QString format = "/cgi-bin/dict/dict-search.pl?search=%s&header=on&links=hide&mirrors=on";
  QString format = "/cgi-bin/leo-result";
#ifndef EA_QT2x
  url.resize (expr.length() + format.length());
#endif
  url.sprintf (format, (const char*) expr);
  return sendQueryUrl (url);
}

/*
  serverLoad("/cgi-bin/leo-result2");
  char buf[100];
  while (ssize_t n = read (sock->socket(), buf, 1) > 0 )
    write (1, buf, n);
  closeConnection ();
*/

/*
const char *server = "localhost";
const unsigned int port = 80;

KSocket        *sock = 0;

int
serverConnect ()
{
    sock = new KSocket (server, port);
    CHECK_PTR (sock);
//    sock->enableWrite (true);
//    sock->enableRead (true);
    return sock->socket ();
}

void
closeConnection ()
{
    delete sock;
}

void
serverLoad (const char *url)
{
    QString         request;
    request = "GET ";
    request += url;
    request += " HTTP/1.0\n";
    request += "Accept: \*\/\*";
    request += "User-Agent: kvoctrain/0.2";
    request += "\n\n";
    int sd = serverConnect();
    write (sd, request, request.length ());
    debug("Getting %s\n", url);
//    closeConnection ();
}

*/

#ifdef __STAND_ALONE

#include "online.moc.cpp"

#endif