/***************************************************************************
                 BlockOptPage.h  -  blocking options page class
                             -------------------                                         
    begin                : Sat Oct 30 13:29:00 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef BlockOptPage_included
#define BlockOptPage_included

#include "BlockOptPageData.h"

#include <time.h>
#include <vector.h>

class QueryManager;

class BlockOptPage : public BlockOptPageData
{
    Q_OBJECT

public:

    BlockOptPage
    (
        QueryManager *manager,
        bool          block,
        bool          expire,
        QWidget      *parent = NULL,
        const char   *name = NULL
    );

    virtual ~BlockOptPage();

    bool getExpire()       const { return expire; }
    bool getBlock()        const { return block; }

    void setStates(bool block, bool expire);

public slots:
    virtual void initFocus() const;

signals:
     void modifySetting(int = -1);
     void blockExpire (bool block, bool expire);

protected:
    void keyPressEvent( QKeyEvent * );
    void setExpireBox (int no, QComboBox*);
    void setBlockBox (int no, QComboBox*);

protected slots:

    virtual void slotSetExpire2(int);
    virtual void slotSetBlock3(int);
    virtual void slotSetExpire3(int);
    virtual void slotSetExpire4(int);
    virtual void slotSetExpire5(int);
    virtual void slotSetExpire1(int);
    virtual void slotSetSetBlock6(int);
    virtual void slotSetSetBlock4(int);
    virtual void slotSetSetBlock5(int);
    virtual void slotSetSetBlock2(int);
    virtual void slotSetExpire6(int);
    virtual void slotSetBlock7(int);
    virtual void slotSetSetBlock1(int);
    virtual void slotSetExpire7(int);
    virtual void slotCheckBlock(bool);
    virtual void slotCheckExpire(bool);

protected:

  QueryManager  *manager;
  bool           block;
  bool           expire;
};
#endif // BlockOptPage_included
