/***************************************************************************
                 QueryOptionsDlg.cpp  -  query options dialog class
                             -------------------                                         
    begin                : Thu Mar 11 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "QueryOptionsDlg.h"
#include "resource.h"

#include <kapp.h>
#include <qcombobox.h>

#include "compat_2x.h"

#define Inherited QTabDialog

class kvoctraindoc;

QueryOptionsDlg::QueryOptionsDlg
(
        int           mqtime,
        kvoctrainDoc *_doc,
        QComboBox    *lessons,
        QueryManager *manager,
        bool          swapdir,
        bool          block,
        bool          expire,
        vector<PreSetting>  preset,
	QWidget      *parent,
	const char   *name
)
	:
	Inherited( parent, name, true ),
        settings(preset)
{
  setCaption( QString(KVOCTRAIN_TITLE) + i18n(": Query Options") );

  setCancelButton();
  groupOptPage = new GroupOptPage (settings, this, name);
  threshOptPage = new ThreshOptPage (manager, lessons, this, name);
  queryOptPage = new QueryOptPage (mqtime, manager,
                                   swapdir, this, name);
  blockOptPage = new BlockOptPage (manager, block, expire, this, name);

  addTab( groupOptPage, i18n("&Groups"));
  connect(groupOptPage, SIGNAL(selectGroup(int)), SLOT(slotSelectGroup(int)) );
  connect(groupOptPage, SIGNAL(newGroup(const QString&)), SLOT(slotNewGroup(const QString&)) );
  connect(groupOptPage, SIGNAL(deleteGroup(int)), SLOT(slotDeleteGroup(int)) );
  connect(groupOptPage, SIGNAL(modifyGroup(int)), SLOT(slotModifyGroup(int)) );
  connect (this, SIGNAL(aboutToShow()), groupOptPage, SLOT(initFocus() ));

  addTab( queryOptPage, i18n("&Query"));
  connect (this, SIGNAL(aboutToShow()), queryOptPage, SLOT(initFocus() ));
  connect(queryOptPage, SIGNAL(modifySetting(int)), SLOT(slotModifyGroup(int)) );

  addTab( threshOptPage, i18n("&Threshholds"));
  connect (this, SIGNAL(aboutToShow()), threshOptPage, SLOT(initFocus() ));
  connect(threshOptPage, SIGNAL(modifySetting(int)), SLOT(slotModifyGroup(int)) );

  addTab( blockOptPage, i18n("&Blocking"));
  connect (this, SIGNAL(aboutToShow()), blockOptPage, SLOT(initFocus() ));
  connect(blockOptPage, SIGNAL(modifySetting(int)), SLOT(slotModifyGroup(int)) );
  connect(blockOptPage,  SIGNAL(blockExpire(bool, bool)),
          threshOptPage, SLOT(slotBlockExpire(bool, bool)) );

  connect( this, SIGNAL(applyButtonPressed()), SLOT(okButton()) );
  connect( this, SIGNAL(cancelButtonPressed()), SLOT(cancelButton()) );

  threshOptPage->slotBlockExpire (getBlock(), getExpire());

  resize( 520+16,360+76 );
  setMinimumSize( 520+16,360+76 );
  setMaximumSize( 520+16,360+76 );
  setIcon (QPixmap (EA_KDEDATADIR("",  "kvoctrain/mini-kvoctrain.xpm" )));
}


QueryOptionsDlg::~QueryOptionsDlg()
{
}


void QueryOptionsDlg::cancelButton()
{
  emit reject();
}


void QueryOptionsDlg::okButton()
{
  emit accept();
}


static bool extract (QString &line, QString &ret)
{
   int lim = line.find (",");
   if (lim < 0) {
     ret = "";
     line = "";
     return false;
   }
   else {
     ret = line.left(lim);
     line.remove (0, lim+1);
   }

   return true;
}


void QueryOptionsDlg::slotSelectGroup(int grp)
{
  if (grp < (int) settings.size() ) {
    QString line = settings[grp].query_set;
    QString s;
    int mqtime = 0;
    bool swap = false;
    if (extract (line, s))
      mqtime = s.toInt();
    if (extract (line, s))
      swap = (bool) s.toInt();
    queryOptPage->setStates (mqtime, swap);

#define QCT(x)  QueryManager::CompType(x)

    line = settings[grp].thresh_set;
    QueryManager manager = getQueryManager();
    if (extract (line, s))
      manager.setLessonItem(s.toInt());
    if (extract (line, s))
      manager.setLessonComp(QCT(s.toInt()));
    if (extract (line, s))
      manager.setTypeItem(s);   // s.toInt()
    if (extract (line, s))
      manager.setTypeComp(QCT(s.toInt()));
    if (extract (line, s))
      manager.setGradeItem(s.toInt());
    if (extract (line, s))
      manager.setGradeComp(QCT(s.toInt()));
    if (extract (line, s))
      manager.setQueryItem(s.toInt());
    if (extract (line, s))
      manager.setQueryComp(QCT(s.toInt()));
    if (extract (line, s))
      manager.setBadItem(s.toInt());
    if (extract (line, s))
      manager.setBadComp(QCT(s.toInt()));
    if (extract (line, s))
      manager.setDateItem(s.toInt());
    if (extract (line, s))
      manager.setDateComp(QCT(s.toInt()));
    threshOptPage->setStates();

#undef QCT

    line = settings[grp].block_set;
    bool block = false;
    bool expire = false;

    if (extract (line, s))
      block = s.toInt();

    if (extract (line, s))
      manager.setBlockItem(1, s.toInt());
    if (extract (line, s))
      manager.setBlockItem(2, s.toInt());
    if (extract (line, s))
      manager.setBlockItem(3, s.toInt());
    if (extract (line, s))
      manager.setBlockItem(4, s.toInt());
    if (extract (line, s))
      manager.setBlockItem(5, s.toInt());
    if (extract (line, s))
      manager.setBlockItem(6, s.toInt());
    if (extract (line, s))
      manager.setBlockItem(7, s.toInt());

    if (extract (line, s))
      expire = (bool) s.toInt();
    if (extract (line, s))
      manager.setExpireItem(1, s.toInt());
    if (extract (line, s))
      manager.setExpireItem(2, s.toInt());
    if (extract (line, s))
      manager.setExpireItem(3, s.toInt());
    if (extract (line, s))
      manager.setExpireItem(4, s.toInt());
    if (extract (line, s))
      manager.setExpireItem(5, s.toInt());
    if (extract (line, s))
      manager.setExpireItem(6, s.toInt());
    if (extract (line, s))
      manager.setExpireItem(7, s.toInt());

    blockOptPage->setStates(block, expire);
  }
}


void QueryOptionsDlg::slotModifyGroup(int grp)
{
  if (grp == -1)
    return;

  if (grp < (int) settings.size() ) {
    QString s, line;

    s.setNum(getMQueryTime());
    line += s + ',';
    s.setNum(getSwapDir());
    line += s + ',';
    settings[grp].query_set = line;

    QueryManager manager = getQueryManager();

    s.setNum(manager.lessonItem());
    line = s + ',';
    s.setNum((int) manager.lessonComp());
    line += s + ',';
    s = manager.typeItem();
    line += s + ',';
    s.setNum((int) manager.typeComp());
    line += s + ',';
    s.setNum(manager.gradeItem());
    line = s + ',';
    s.setNum((int) manager.gradeComp());
    line += s + ',';
    s.setNum(manager.queryItem());
    line += s + ',';
    s.setNum((int) manager.queryComp());
    line += s + ',';
    s.setNum(manager.badItem());
    line += s + ',';
    s.setNum((int) manager.badComp());
    line += s + ',';
    s.setNum(manager.dateItem());
    line += s + ',';
    s.setNum((int) manager.dateComp());
    line += s + ',';
    settings[grp].thresh_set = line;


    s.setNum(getBlock());
    line = s + ',';
    for (int i = KV_LEV1_GRADE; i <= KV_MAX_GRADE; i++) {
      s.setNum(manager.blockItem(i));
      line += s + ',';
    }
  
    s.setNum(getExpire());
    line += s + ',';
    for (int i = KV_LEV1_GRADE; i <= KV_MAX_GRADE; i++) {
      s.setNum(manager.expireItem(i));
      line += s + ',';
    }
    settings[grp].block_set = line;
  }

}


void QueryOptionsDlg::slotDeleteGroup(int grp)
{
  if (grp < (int) settings.size() )
    settings.erase (&settings[grp], &settings[grp+1]);
}


void QueryOptionsDlg::slotNewGroup(const QString &name)
{
  settings.push_back(PreSetting(name, "", "", ""));
  slotModifyGroup(settings.size()-1);
}
