#include "CubeContainer.h"
#include <cstring>
#include <cstdio>

CubeContainer::CubeContainer (const int _sizeX, const int _sizeY, const char _sizeZ)
{
	sizeX=_sizeX;
	sizeY=_sizeY;
	sizeZ=_sizeZ;
	
	sizeXY=sizeX*sizeY;
	size=sizeXY*sizeZ;

	cubes=new const Color*[size];
	memset (cubes, 0, sizeof (Color*)*size);
}

CubeContainer::CubeContainer()
{
	sizeX=sizeY=sizeZ=sizeXY=size=0;
	
	cubes=0;
}

CubeContainer& CubeContainer::operator= (const CubeContainer& _oldCube)
{
	sizeX=_oldCube.sizeX;
	sizeY=_oldCube.sizeY;
	sizeZ=_oldCube.sizeZ;
	
	sizeXY=_oldCube.sizeXY;
	size=_oldCube.size;

	
	cubes=new const Color*[size];
	memset (cubes, 0, sizeof (Color*)*size);

	// copy colors

	const Color **cube=cubes;
	const Color **cubeOld=_oldCube.cubes;
	for (int i=0;i<size; i++)
	{
		if (*cubeOld)
		{
			const Color *c=new Color (**cubeOld);
			*cube=c;
		}
		cube++;
		cubeOld++;
	}

	return *this;
}


CubeContainer::~CubeContainer()
{
	clear();

	delete[] cubes;
}

void CubeContainer::addCube (const Position& pos, const Color* color, const Color** buffer)
{
	int index=get3DIndex (pos);

	buffer [index]=color;
}


int CubeContainer::getCountOfCubes() const
{
	int count=0;
	const Color **color=cubes;

	for (int i=0; i<size;i++)
	{
		if (*color)
			count++;
		color++;
	}

	return count;
}

void CubeContainer::clear (bool remove)
{
	const Color **cube=cubes;

	for (int i=0; i<size; i++)
	{
		if (*cube && remove)
			delete *cube;

		cube++;
	}

	memset (cubes, 0, sizeof (Color*)*size);
}


void CubeContainer::incrementPosition (int *x, int *y, int *z) const
{
	(*x)++;
	if (*x >= sizeX)
	{
		(*y)++;
		*x=0;
	}
	if (*y >= sizeY)
	{
		(*z)++;
		*y=0;
	}
}

// Local Variables:
// compile-command: "make CubeContainer.o"
// End:
