#include "Figure.h"
#include <cstring>
#include <cstdio>

Figure::Figure (const int _sizeX, const int _sizeY, const char _sizeZ) : CubeContainer (_sizeX, _sizeY, _sizeZ)
{
	moveTo (Position (0, 0, 0));
}

Figure::Figure() : CubeContainer()
{
}

Figure& Figure::operator= (const Figure& _oldFigure)
{
	(CubeContainer &)*this=(CubeContainer &) _oldFigure;

	origin=_oldFigure.origin;

	return *this;
}

Figure* Figure::rotateX (const int direction)
{
	Figure *fig = new Figure(sizeX, sizeZ, sizeY);
	fig->moveTo (origin);

	const Color **cube=cubes;

	for (int z=0; z<sizeZ; z++)
		for (int y=0; y<sizeY; y++)
			for (int x=0; x<sizeX; x++)
			{
				int nx=x;
				int ny;
				int nz;
				
				if (direction == 1)
				{
					ny=z;
					nz=sizeY-1-y; // 0<=y<sizeY
				} else {
					ny=sizeZ-1-z; // 0<=z<sizeZ
					nz=y;
				}
				fig->addCube (Position (nx, ny, nz), *cube);

				cube++;
			}
	return fig;
}

Figure* Figure::rotateY (const int direction)
{
	Figure *fig = new Figure(sizeZ, sizeY, sizeX);
	fig->moveTo (origin);

	const Color **cube=cubes;

	for (int z=0; z<sizeZ; z++)
		for (int y=0; y<sizeY; y++)
			for (int x=0; x<sizeX; x++)
			{
				int nx;
				int ny=y;
				int nz;
				
				if (direction == 1)
				{
					nx=z;
					nz=sizeX-1-x; // 0<=x<sizeX
				} else {
					nx=sizeZ-1-z; // 0<=z<sizeZ
					nz=x;
				}
				fig->addCube (Position (nx, ny, nz), *cube);

				cube++;
			}
	return fig;
}

Figure* Figure::rotateZ (const int direction)
{
	Figure *fig = new Figure(sizeY, sizeX, sizeZ);
	fig->moveTo (origin);

	const Color **cube=cubes;

	for (int z=0; z<sizeZ; z++)
		for (int y=0; y<sizeY; y++)
			for (int x=0; x<sizeX; x++)
			{
				int nx;
				int ny;
				int nz=z;
				
				if (direction == -1)
				{
					nx=y;
					ny=sizeX-1-x; // 0<=x<sizeX
				} else {
					nx=sizeY-1-y; // 0<=y<sizeY
					ny=x;
				}
				fig->addCube (Position (nx, ny, nz), *cube);

				cube++;
			}
	return fig;
}

void Figure::moveTo (const Position& newPos)
{
	origin=newPos;
}

void Figure::moveRel (const Position& rel)
{
	origin+=rel;
}
// Local Variables:
// compile-command: "make Figure.o"
// End:
