/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/   

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include <qlabel.h>
#include <qpushbt.h>
#include <qgrpbox.h>
#include <qframe.h>
#include <qslider.h>

#include <kapp.h> 
#include <kcolorbtn.h> 
#include <klocale.h>

/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "levelGenDialog.h"


/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/

levelItem::levelItem( QWidget *parent, QList<enemyListEntry> enemyEntries, int x, int y )
{
  
  xpos = x;
  ypos = y;
  
  leftBtn = new KDirectionButton( LeftArrow, parent, "kdirection");
  leftBtn->setGeometry( x, y +40 , 20, 15 );
	connect( leftBtn, SIGNAL(clicked()), SLOT(leftArrowClicked()) );

  rightBtn = new KDirectionButton( RightArrow, parent, "kdirection");
  rightBtn->setGeometry( x+20, y+40, 20, 15 );
	connect( rightBtn, SIGNAL(clicked()), SLOT(rightArrowClicked()) );

  picBtn=new QLabel( parent );
  picBtn->setGeometry( x+5, y+10, 30, 30 );
    
  enemyList = enemyEntries;
  
  enemyListEntry  *enemy;
  enemy =  enemyList.first();
  if ( enemy != 0 )
  {
    picBtn->setPixmap ( enemy->pic );
  }
  
}

levelItem::~levelItem( )
{
  delete picBtn;
  delete rightBtn;
  delete leftBtn;
}

void levelItem::leftArrowClicked()
{
  enemyListEntry  *enemy;
  
  printf( "leftClick\n");
  enemy =  enemyList.prev();
  if ( enemy != 0 )
  {
    picBtn->setPixmap ( enemy->pic );
  }
  else
  {
    enemy =  enemyList.last();    
    if ( enemy != 0 )
    {
      picBtn->setPixmap ( enemy->pic );
    }
  }
  
}

void levelItem::rightArrowClicked()
{
  enemyListEntry  *enemy;
  
  printf( "rightClick\n");
  enemy =  enemyList.next();
  if ( enemy != 0 )
  {
    picBtn->setPixmap ( enemy->pic );
  }
  else
  {
    enemy =  enemyList.first();    
    if ( enemy != 0 )
    {
      picBtn->setPixmap ( enemy->pic );
    }
  }
  
}

enemyListEntry* levelItem::getCurrent()
{
  return( enemyList.current());
}

void levelItem::clearEnemy()
{
  enemyListEntry  *enemy;
  enemy =  enemyList.first();
  if ( enemy != 0 )
  {
    picBtn->setPixmap ( enemy->pic );
  } 
}

  
  

levelGenDialog::levelGenDialog( QString enemyPath )
              :QDialog ( 0, 0, true )  
{
	  
  QGroupBox* dlgedit_GroupBox_1;
	dlgedit_GroupBox_1 = new QGroupBox( this, "GroupBox_1" );
	dlgedit_GroupBox_1->setGeometry( 10, 10, 600, 400 );
	dlgedit_GroupBox_1->setFrameStyle( 49 );
	dlgedit_GroupBox_1->setAlignment( 1 );

  enemyList.setAutoDelete( true );
  enemyListEntry  *enemyEntry;
  
  
  enemyEntry=new enemyListEntry;
  enemyEntry->pic= QPixmap( ); 
  enemyEntry->enemytype = 0;
  enemyList.append( enemyEntry );
  
  enemyEntry=new enemyListEntry;
  enemyEntry->pic= QPixmap( enemyPath + "/enemy_1.18.ppm" );
  enemyEntry->enemytype = 1;
  enemyList.append( enemyEntry );
  
  enemyEntry=new enemyListEntry;
  enemyEntry->pic= QPixmap( enemyPath + "/enemy_2.18.ppm" );
  enemyEntry->enemytype = 2;
  enemyList.append( enemyEntry );
  
  enemyEntry=new enemyListEntry;
  enemyEntry->pic= QPixmap( enemyPath + "/enemy_3.18.ppm" );
  enemyEntry->enemytype = 3;
  enemyList.append( enemyEntry );
  
  enemyEntry=new enemyListEntry;
  enemyEntry->pic= QPixmap( enemyPath + "/enemy_4.18.ppm" );
  enemyEntry->enemytype = 4;
  enemyList.append( enemyEntry );
  
  
  levelItemList.setAutoDelete( true );
  for ( int y=5; y < 350; y=y+40 )
  {
    for ( int x=5; x < 600; x=x+50 )
    {
      levelItem *lItem;
      lItem = new levelItem( dlgedit_GroupBox_1, enemyList, x, y );
      levelItemList.append( lItem );
    }
  }

	
  
  QPushButton* dlgedit_PushButton_1;
	dlgedit_PushButton_1 = new QPushButton( this, "PushButton_1" );
	dlgedit_PushButton_1->setGeometry( 10, 460, 100, 30 );
	dlgedit_PushButton_1->setText( klocale->translate("Ok") );
	dlgedit_PushButton_1->setAutoRepeat( FALSE );
	dlgedit_PushButton_1->setAutoResize( FALSE );
	connect( dlgedit_PushButton_1, SIGNAL(clicked()), SLOT(okBtnClicked()) );

	QPushButton* dlgedit_PushButton_2;
	dlgedit_PushButton_2 = new QPushButton( this, "PushButton_2" );
	dlgedit_PushButton_2->setGeometry( 120, 460, 100, 30 );
	dlgedit_PushButton_2->setText( klocale->translate("Print") );
	dlgedit_PushButton_2->setAutoRepeat( FALSE );
	dlgedit_PushButton_2->setAutoResize( FALSE );
	connect( dlgedit_PushButton_2, SIGNAL(clicked()), SLOT(cancelBtnClicked()) );

	QPushButton* dlgedit_PushButton_4;
	dlgedit_PushButton_4 = new QPushButton( this, "PushButton_2" );
	dlgedit_PushButton_4->setGeometry( 230, 460, 100, 30 );
	dlgedit_PushButton_4->setText( klocale->translate("Clear Boxes") );
	dlgedit_PushButton_4->setAutoRepeat( FALSE );
	dlgedit_PushButton_4->setAutoResize( FALSE );
	connect( dlgedit_PushButton_4, SIGNAL(clicked()), SLOT(clearBoxes()) );
	
  
  QPushButton* dlgedit_PushButton_3;
	dlgedit_PushButton_3 = new QPushButton( this, "PushButton_3" );
	dlgedit_PushButton_3->setGeometry( 340, 460, 100, 30 );
	dlgedit_PushButton_3->setText( klocale->translate("Help") );
	dlgedit_PushButton_3->setAutoRepeat( FALSE );
	dlgedit_PushButton_3->setAutoResize( FALSE );
	connect( dlgedit_PushButton_3, SIGNAL(clicked()), SLOT(helpBtnClicked()) );
	
  resize( 620, 500 );
  setCaption( klocale->translate("Level Generator"));

}


levelGenDialog::~levelGenDialog()
{
  levelItemList.clear();
}


void levelGenDialog::okBtnClicked()
{
  done(1);
}

void levelGenDialog::cancelBtnClicked()
{
  
  levelItem *lItem;enemyListEntry *enemyEntry;
  for ( lItem = levelItemList.first(); lItem != 0; lItem = levelItemList.next() )
  {
    enemyEntry=lItem->getCurrent();
    if ( enemyEntry -> enemytype != 0 )
    {
      fprintf( stdout, "%d %d %d\n", lItem->xpos+5, lItem->ypos+35, enemyEntry->enemytype - 1 );      
    }
  }

  
}

void levelGenDialog::clearBoxes()
{
   
  levelItem *lItem;
  for ( lItem = levelItemList.first(); lItem != 0; lItem = levelItemList.next() )
  {
    lItem->clearEnemy();
  }
}


void levelGenDialog::helpBtnClicked()
{
#if 0
  QString filename( APPNAME "/kdiff-4.html" );

  // kapp is defined in kapp.h as #define kapp KApplication::getKApplication()
  kapp->invokeHTMLHelp( filename,"ss4.2");
#endif
}


