/***************************************************************************
                          kbattlefield.cpp  -  description
                             -------------------
    begin                : Sat Sep 11 1999
    copyright            : (C) 1999 by Alessandro Praduroux
    email                : pradu@geocities.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

 //standard include files
#include <fstream.h>
#include <iostream.h>

// include files for Qt
#include <qpainter.h>
#include <qpixmap.h>

// include files for KDE
#include <ksock.h>
#include <kapp.h>

// application specific includes
#include "kbattlefield.h"

KBattleField::KBattleField (QWidget * parent, const char *name)
:KBattleshipViewBase (parent, name), active (false)
{
  setFixedSize (320, 320);
  setMouseTracking (true);
}

KBattleField::~KBattleField ()
{
}

/**  */
void KBattleField::paintEvent (QPaintEvent *)
{
  QPainter p;
  QPixmap pix(geometry().size());
  QPainter myPaint;

  pix.fill(this,geometry().topLeft());
  p.begin (&pix);

  paintField (&p);
  paintShips (&p);

  p.end ();

  myPaint.begin(this);
  myPaint.drawPixmap(0,0,pix);
  myPaint.end();

}


/** used to view the cell that is under the mouse */
void KBattleField::mouseMoveEvent (QMouseEvent * e)
{
  int cellX, cellY;

  cellX = (e->x () - 10) / 20;
  cellY = (e->y () - 10) / 20;
}

/**  */
void KBattleField::paintField (QPainter * p)
{
  QPen penBlack (black);
  QRect r;

  // draw background pixmap
  p->setPen (penBlack);
  QString picDir(kapp->kde_datadir() + "/kbattleship/pics/");
  QPixmap field (picDir + "field.xpm");
  p->drawPixmap (10, 10, field);


  // draw grid
  r = field.rect ();
  r.moveBy (10, 10);
  p->drawRect (r);
  for (int i = 10; i < 300; i += 20)
    {
      p->drawLine (10, i, width () - 11, i);
      p->drawLine (i, 10, i, height () - 11);
    }

}

/**  */
void KBattleField::paintShips (QPainter * p)
{

}

/**  */
void KBattleField::mouseReleaseEvent (QMouseEvent * e)
{
  int cellX, cellY;

  // funziona solo se il campo di battaglia e' attivo
  if (!isActive ())
    return;

  // determina la cella su cui ho clikkato
  cellX = (e->x () - 10) / 20;
  cellY = (e->y () - 10) / 20;

  cellClicked (cellX, cellY, e->button ());
}

/**  */
void KBattleField::cellClicked (int x, int y, int button)
{
}


/** rende attivo il campo di battaglia */
void KBattleField::activate ()
{
  active = true;
}

/** disattiva il campo di battaglia */
void KBattleField::deactivate ()
{
  active = false;
}

/** ritorna lo stato del campo di battaglia */
bool KBattleField::isActive ()
{
  return active;
}

/**  */
void KBattleField::updateView()
{
	cerr << "updateView " << name() << endl;
	repaint();
}
