/***************************************************************************
                          kbattleshipserver.cpp  -  description
                             -------------------
    begin                : Sun Dec 12 1999
    copyright            : (C) 1999 by Alessandro Praduroux
    email                : pradu@tiscalinet.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//standard include files
#include <iostream.h>

// include files for Qt

// include files for KDE
#include <ksock.h>
#include <kapp.h>

// application specific includes
#include "kbattleshipserver.h"
#include "kmessage.h"
#include "resource.h"


KBattleshipServer::KBattleshipServer()
{
	serverSocket = 0;
	do {
		if (serverSocket)
			delete serverSocket;
		serverSocket = new KServerSocket(ID_PORT);	
	} while (serverSocket->socket() == -1);
	
	connect(serverSocket, SIGNAL(accepted(KSocket *)),this,SLOT(slotAccepted(KSocket *)));
	
	cliSock = 0;
	
}

KBattleshipServer::~KBattleshipServer()
{
	if (serverSocket)
		delete serverSocket;
	
	if (cliSock)
		delete cliSock;
}


/**  */
//int
//Del di KDevelop: KBattleshipServer::cellStatus(int x, int y, int who)
//Del di KDevelop: {
//Del di KDevelop: 	return 0;
//Del di KDevelop: }

/**  */
//void
//Del di KDevelop: KBattleshipServer::fire(int x, int y)
//Del di KDevelop: {
//Del di KDevelop: }

/** sets the name of the fleet */
void
KBattleshipServer::setName(QString name)
{
	_name = name;
	area = MY_AREA;
}

/**  */
QString KBattleshipServer::fleetName()
{
	return _name;
}

/** this is called when the server socket accepts a new connection */
void KBattleshipServer::slotAccepted(KSocket * sock)
{
	if (cliSock)
		return;
		
	cliSock = sock;			
	connect(cliSock,SIGNAL(readEvent(KSocket *)),this,SLOT(slotReadEvent(KSocket *)));
	connect(cliSock,SIGNAL(closeEvent(KSocket *)),this,SLOT(slotCloseEvent(KSocket *)));
	cliSock->enableRead(true);
}


/**  */
QString KBattleshipServer::enemyName()
{
	return _enemy;
}

/**  */
void KBattleshipServer::processMsg(KMessage & msg)
{
	bool changed = false;
	
	switch (msg.getType())
		{
			case IDM_NAME:
				_enemy = msg.getField("name");
				msg.clear();
				msg.setType(IDM_NAME);
				msg.addField("name",_name);
				sendMessage(msg);
				_status = PLACE;
				area = ALL_AREA;
				changed = true;							
				break;
			
			default:
				break;
		}

	if (changed)
		emit dataChanged();
		
	KBattleshipDocBase::processMsg(msg);

}
/**  */
void KBattleshipServer::endShips()
{
	if (ready && enemyReady)
		{
			_status = FIRE;
			area = ENEMY_AREA;
			getApplication()->slotStatusMsg(i18n("Ready to fire"));
		}
}
