#include "bet_option.h" 
#include <qpushbt.h>
#include <qradiobt.h> 

#include <stream.h>


BetOption::
BetOption(float min, float max, float inc, QWidget* parent) : 
          QDialog(parent, "", TRUE), _num_bets(0), _num_incs(0) {
   int i;
   _min_bg = new QButtonGroup(this, "MinBetGroup");
   _min_bg->setTitle("Minimum Bet");
   _max_bg = new QButtonGroup(this, "MaxBetGroup");
   _max_bg->setTitle("Maximum Bet");
   _inc_bg = new QButtonGroup(this, "IncBetGroup");
   _inc_bg->setTitle("Bet Increment");

   _pad = 10;
   _btn_height = 26;
   _btn_width  = 90;

   _bet_list.setAutoDelete(TRUE);
   _bet_list.append(new float(1.0));
   _bet_list.append(new float(2.0));
   _bet_list.append(new float(3.0));
   _bet_list.append(new float(5.0));
   _bet_list.append(new float(10.0));
   _bet_list.append(new float(25.0));
   _bet_list.append(new float(50.0));
   _bet_list.append(new float(100.0));
   _bet_list.append(new float(250.0));
   _bet_list.append(new float(500.0));

   _bet_inc_list.setAutoDelete(TRUE);
   _bet_inc_list.append(new float(0.10));
   _bet_inc_list.append(new float(0.50));
   _bet_inc_list.append(new float(1.00));
   _bet_inc_list.append(new float(5.00));
   _bet_inc_list.append(new float(10.00));
   _bet_inc_list.append(new float(25.00));
   _bet_inc_list.append(new float(50.00));
   _bet_inc_list.append(new float(100.00));

   for (i = 0; i < _bet_list.count(); i++)
      addBet(*(_bet_list.at(i)));

   for (i = 0; i < _bet_inc_list.count(); i++)
      addBetInc(*(_bet_inc_list.at(i)));

   setMin(min);
   setMax(max);
   setInc(inc);

   _min_bg->setGeometry(_pad, _pad, 
                        _btn_width + 2 * _pad, (_num_bets + 1) * _btn_height);
   _max_bg->setGeometry(_min_bg->width() + 2 * _pad, _pad, 
                        _btn_width + 2 * _pad, (_num_bets + 1) * _btn_height);
   _inc_bg->setGeometry(_min_bg->width() + _max_bg->width() + 3 * _pad, _pad, 
                        _btn_width + 2 * _pad, (_num_incs + 1) * _btn_height);

   connect(_min_bg, SIGNAL(pressed(int)), SLOT(minBetPressed(int)));
   connect(_max_bg, SIGNAL(pressed(int)), SLOT(maxBetPressed(int)));
   connect(_inc_bg, SIGNAL(pressed(int)), SLOT(betIncPressed(int)));

   int width = _min_bg->width() + _max_bg->width() + _inc_bg->width() + 
               4 * _pad;
   int x1, x2, y;
 
   x1 = width / 3 - _btn_width / 2;
   x2 = width * 2 / 3 - _btn_width / 2;

   y = _min_bg->height();
   y = _max_bg->height() > y ? _max_bg->height() : y;
   y = _inc_bg->height() > y ? _inc_bg->height() : y;
   y += _pad *2;

   QPushButton *ok, *cancel;
   ok = new QPushButton("OK", this);
   ok->setGeometry(x1, y, _btn_width, _btn_height);
   connect(ok, SIGNAL(clicked()), SLOT(accept()));
   cancel = new QPushButton("Cancel", this);
   cancel->setGeometry(x2, y, _btn_width, _btn_height);
   connect(cancel, SIGNAL(clicked()), SLOT(reject()));

   setFixedSize(width, y + _btn_height + _pad);
}


void BetOption::
addBet(float bet) { 
   int half_height = _btn_height / 2;
   QRadioButton *rb;

   QString bet_str;
   bet_str.sprintf("$%6.2f", bet);
   _num_bets++; 

   rb = new QRadioButton(bet_str, _min_bg);
   rb->setGeometry(10, _num_bets * _btn_height - half_height, 
                   _btn_width, _btn_height);

   rb = new QRadioButton(bet_str, _max_bg);
   rb->setGeometry(10, _num_bets * _btn_height - half_height, 
                   _btn_width, _btn_height);
}


void BetOption::
addBetInc(float inc) { 
   int half_height = _btn_height / 2;
   QRadioButton *rb;

   QString inc_str;
   inc_str.sprintf("$%6.2f", inc);
   _num_incs++; 

   rb = new QRadioButton(inc_str, _inc_bg);
   rb->setGeometry(10, _num_incs * _btn_height - half_height, 
                   _btn_width, _btn_height);
}


void BetOption::
setMin(float min) {
   int i, best;
   QRadioButton *rb = (QRadioButton *)_min_bg->find(0);
   QListIterator<float> it(_bet_list);

   _bet_min = *_bet_list.at(0);

   for (i = 0, best = 0; it.current(); ++it, i++) {
      if (*it.current() <= min)
         best = i;
      else
         break;
   }
   minBetPressed(best);
   rb = (QRadioButton *)_min_bg->find(best);
   rb->setChecked(TRUE);
   _bet_min = *_bet_list.at(best);
}


void BetOption::
setMax(float max) {
   int i, best;
   QRadioButton *rb = (QRadioButton *)_max_bg->find(0);
   QListIterator<float> it(_bet_list);

   _bet_max = *_bet_list.at(0);

   for (i = 0, best = 0; it.current(); ++it, i++) {
      if (*it.current() <= max)
         best = i;
      else
         break;
   }
   maxBetPressed(best);
   rb = (QRadioButton *)_max_bg->find(best);
   rb->setChecked(TRUE);
}


void BetOption::
setInc(float inc) {
   int i, best;
   QRadioButton *rb = (QRadioButton *)_inc_bg->find(0);
   QListIterator < float >it (_bet_inc_list);

   _bet_inc = *_bet_inc_list.at(0);

   for (i = 0, best = 0; it.current(); ++it, i++) {
      if (*it.current() <= inc)
         best = i;
      else
         break;
   }
   rb = (QRadioButton *)_inc_bg->find(best);
   _bet_inc = *_bet_inc_list.at(best);
   rb->setChecked(TRUE);
}


BetOption::
minBetPressed(int id) {
   int i;
   QButton *qb;
 
   _bet_min = *_bet_list.at(id);   

   for (i = 0; qb = _max_bg->find(i); i++) {
      if (i < id)
         qb->setEnabled(FALSE);
      else
         qb->setEnabled(TRUE);
   }

   if (_bet_inc > _bet_min)
      setInc(_bet_min); 

   for (i = 0; qb = _inc_bg->find(i); i++) {
      if (*_bet_inc_list.at(i) <= _bet_min)
         qb->setEnabled(TRUE);
      else {
         QRadioButton *rb = (QRadioButton *)qb;
         if (rb->isChecked())
            rb->setChecked(FALSE);
         qb->setEnabled(FALSE);
      }
   }
}


BetOption::
maxBetPressed(int id) {
   QButton *rb;
 
   _bet_max = *_bet_list.at(id);   
   for (int i = 0; rb = _min_bg->find(i); i++) {
      if (i > id)
         rb->setEnabled(FALSE);
      else
         rb->setEnabled(TRUE);
   }
}


BetOption::
betIncPressed(int id) {
   _bet_inc = *_bet_inc_list.at(id);   
}

