#include "dollar_scroll_bar.h"


QtedDollarScrollBar::
QtedDollarScrollBar(const char *label, float min, float max, float inc,
                   QWidget *parent, const char *name) : _label_text(label),
                   QWidget(parent, name) {
   _label_p = new QLabel(_label_text, this);
   _label_p->setAlignment(AlignCenter);

   _sb_p = new QScrollBar(0, 1, 1, 1, 0, QScrollBar::Horizontal, this);
   setRange(min, max, inc);
   setText(0);
   connect(_sb_p, SIGNAL(valueChanged(int)), this, SLOT(setText(int)));
   connect(_sb_p, SIGNAL(sliderReleased()), this, SLOT(betMade()));
   resizeEvent(NULL);
}


float QtedDollarScrollBar::
getValue(void) {
   int cents;

   cents = (int)(_min * 100.0);
   cents += (int)(_inc * 100.0 * _sb_p->value());
   if (cents / 100.0 > _max)
      cents = (int)(_max * 100.0);
   return(cents / 100.0);
}


void QtedDollarScrollBar::
setRange(float min, float max, float inc) {
   int page, scroll_max;
   _min = min;
   _max = max;
   _inc = inc;
   int min_cent = (int)(_min * 100.0), max_cent = (int)(_max * 100.0);
   int inc_cent = (int)(_inc * 100.0);

   scroll_max = (max_cent - min_cent) / inc_cent;
   if ((max_cent - min_cent) % inc_cent)
      scroll_max++;
   _sb_p->setRange(0, scroll_max);
  
   page = 100 / inc_cent;		// minimum page step is $1.00 
   if (max_cent - min_cent > 1000)
      page = 500 / inc_cent;
   if (max_cent - min_cent > 2500)
      page = 1000 / inc_cent;
   if (max_cent - min_cent > 10000)
      page = 2000 / inc_cent;
   if (page == 0)
      page = 1;

   _sb_p->setSteps(1, page);
   setText(0);
}


void QtedDollarScrollBar::
setText(int value) {
   QString str;
   str.sprintf("%s$%4.2f", (const char *)_label_text, getValue());
   _label_p->setText(str);
}


void QtedDollarScrollBar::
resizeEvent(QResizeEvent *) {
   _label_p->setGeometry(0, 0, width(), height()/2);
   _sb_p->setGeometry(0, height()/2, width(), height()/2);
}


void QtedDollarScrollBar::
betMade() {
   emit valueSet(getValue());
}

