#include <iostream.h>
#include <qpainter.h>
#include "hand.h"


Card *Hand::
removeCard(void) {
   Card *cp = _cards.last();
   _cards.removeLast();

   calculateValue();

   return (cp);
}


void Hand::
calculateValue(void) {
   int i, ace_flag = 0;
   Card *cp;
   Card::RankType rank;

   _value = 0;
   for(i = 0; i < _cards.count(); i++) {
      cp = _cards.at(i);
      rank = cp->getRank();
      if (rank == Card::ACE) {
         ace_flag = 1;
         _value += 1;
      } else if (rank == Card::KING ||
                 rank == Card::QUEEN ||
                 rank == Card::JACK)
         _value += 10;
      else 
         _value += rank;
   }

   _soft_flag = 0;

   if (ace_flag && _value <= 11) {
         _soft_flag = 1;
         _value += 10;
   }
}


void Hand::
setAllCardsUp(void) {
   for (int i = 0; i < _cards.count() ; i++)
      _cards.at(i)->setDirection(Card::FACE_UP);
}


void Hand::
draw(QPaintDevice *device_p, int x, int y) {
   int i, last_card, card_x;
   int card_overlap = 30;
   QPixmap *pixmap_p;

   last_card = _cards.count() - 1;

   for (i = 0, card_x = x; i <= last_card; i++, card_x += card_overlap) {
      Card *card_p = _cards.at(i);
      if (pixmap_p = card_p->getPixmap()) {
         QPainter painter;
         if ((painter.begin(device_p)) == FALSE) {
            cerr << "hand::draw(): Can't open paint device\n";
         } else {
            if (i == last_card)
               painter.drawPixmap(card_x, y, *pixmap_p);
            else
               painter.drawPixmap(card_x, y, *pixmap_p,
                                  0, 0, card_overlap + 5, -1);
            painter.end();
         }
      }
   }
}


int Hand::
isSplitable(void) {
   int result = 0;

   if (numCards() == 2) {
      Card::RankType rank1, rank2;

      rank1 = getCard(0)->getRank();
      rank2 = getCard(1)->getRank();

      if (rank1 == Card::KING || rank1 == Card::QUEEN || rank1 == Card::JACK)
         rank1 = Card::TEN;
      if (rank2 == Card::KING || rank2 == Card::QUEEN || rank2 == Card::JACK)
         rank2 = Card::TEN;
      if (rank1 == rank2)
         result = 1; 
   }

   return (result);
}


QString Hand::
getHelpIndex(void) {
   QString result;
   if (isSplitable()) {
      if (value() == 12 && isSoft())
         result = "AA";
      else if (value() == 20)
         result = "XX";
      else {
         int half = value() / 2;
         result.sprintf("%d%d", half, half);
      }
   } else if (isSoft()) {
      if (value() == 21)
         result = "AX";
      else
         result.sprintf("A%d", value() - 11);
   } else {
      result.sprintf("%d", value());
   }

   return (result); 
}

