#include <qpushbt.h>
#include <qlabel.h>
#include "dollar_scroll_bar.h"
#include "insurance_window.h"


InsuranceWindow::
InsuranceWindow(float max_bet, float bet_inc, QWidget *parent, const char* name,
                bool modal, WFlags f) : 
                QDialog(parent, name, modal, f) {

   int b_width = 40, b_height = 25, b_space = 10, l_height = 20;
   int x = 0, y = 0, width = 140, height = 140;

   QLabel *label_p = new QLabel("Insurance?", this);
   label_p->setAlignment(AlignCenter);
   label_p->setGeometry(x, y, width, height/3);

   y += height/3;
   _bet_p = new QtedDollarScrollBar("Bet = ", 0.0, max_bet, bet_inc, this);
   _bet_p->setGeometry(x, y, width, height/3);

   y += height/3;
   QPushButton *ok_p = new QPushButton("OK", this);
   ok_p->setGeometry((width - b_width)/2, y + b_space, 
                     b_width, b_height);

   connect(ok_p, SIGNAL(released()), this, SLOT(accept()));
   setFixedSize(width, height);
}

