/***************************************************************************
                          kblackjack.h  -  description                              
                             -------------------                                         

    version              : 0.3                                  
    begin                : Mit Okt 21 08:57:03 CEST 1998
                                           
    copyright            : (C) 1998 by The BerLinuX                         
    email                : the.berlinux@berlinux.in-berlin.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef _BLACKJACK_INCLUDED_
#define _BLACKJACK_INCLUDED_

#include <kpopmenu.h>
#include <kmenubar.h> 
#include <qdict.h>

#include "user_input.h" 
#include "status_display.h" 
#include "table.h" 
#include "shoe.h"


#define DEFAULT_HELP_FILE ".blackjackrc"
#define MAX_SPLITS	3


class BlackJack : public QWidget {
      Q_OBJECT
   private:
      enum HelpLevel { FULL_HELP, WARNING, PICKEY, NO_HELP, BAD_HELP };
      enum ShuffleCode { NO_SHUFFLE, DECKS_CHANGED, OUT_OF_CARDS };
      HelpLevel _help;
      KMenuBar *_menu_bar_p;
      StatusDisplay *_status_p; 
      UserInput *_input_p; 
      CardTable *_table_p; 
      Shoe *_shoe_p; 
      int   _current_player_hand;	// starts at 1
      short _dealer_must_play;
      short _hand_in_progress;
      float _min_bet;
      float _max_bet;
      float _bet_inc;
      float _bank_roll;
      int   _shuffle;		// re-shuffle after current hand (flag)
      int   _decks;		// number of decks in shoe
      int   _shuffle_threshold;	// shuffle if # cards in shoe falls below
      int   _max_splits;
      QDict<QString> _help_dict;
 
      void playDealerHand(void);
      void insurance(void);
      void checkShuffle(void);
      void dealCards(void);
      void postDealChecks(void);
      void endOfHands(void);
      void nextHand(void);
      void checkForSplit(void);

      void    readHelpFile(char *name = "");
      QString createHelpFile(QString name);
      QString readHelpLine(QString line);
      QString readVariableLine(QString line);
      QString makeOptionLine(QString name);
      int     addHelpEntry(QString key, QString value);
      QString getHelpIndex(void);
      QString getHelpText(QString help_letters);
      void    checkPreHelp(void); // Full help gives msg before player action
      int     checkPostHelp(char action); // other help gives message after

   public:
      BlackJack(QWidget *parent=0, const char *name=0);
      ~BlackJack();

   private:
      void makeValid(UserInput::InputFlags flags) {
           _input_p->makeValid(flags);
      }
      void makeInvalid(UserInput::InputFlags flags) {
           _input_p->makeInvalid(flags);
      }
      void setHelp(const char *help_text) { 
           _status_p->setHelp(help_text); 
      }
      void setResults(float mult, float bet) {
           _status_p->setResults(mult, bet);
      }
      void outOfCards(void);
   protected:
      void resizeEvent(QResizeEvent *);
   public slots:
      void hit();
      void split();
      void doubleDown();
      void stand();
      void bet();
      void noHelp() { _help = NO_HELP; _status_p->setHelp("No Help"); }
      void warnHelp() { _help = WARNING; _status_p->setHelp("Warning"); }
      void pickeyHelp() { _help = PICKEY; _status_p->setHelp("Pickey"); }
      void fullHelp() { _help = FULL_HELP; checkPreHelp(); }
      void betOptions();
      void tableOptions();
      void saveOptions();
};

#endif


