#ifndef _USER_INPUT_INCLUDED_
#define _USER_INPUT_INCLUDED_

#include <qlabel.h>
#include <qscrbar.h>
#include <qpushbt.h>

#include "dollar_scroll_bar.h"


class UserInput : public QWidget {
   private:
      QPushButton *_split_p;
      QPushButton *_double_down_p;
      QPushButton *_hit_p;
      QPushButton *_stand_p;
      QPushButton *_bet_p;
      QtedDollarScrollBar *_bet_sb_p;
   public:
      UserInput(float min_bet, float max_bet, float bet_inc, 
                QWidget *parent=0, const char *name=0);
      enum InputFlags { Stand  = 0x0001,
                        Hit    = 0x0002,
                        Double = 0x0004,
                        Split  = 0x0008,
                        Bet    = 0x0010 };
      void  makeValid(int flags);
      void  makeInvalid(int flags);
      float getBet(void) { return(_bet_sb_p->getValue()); }
      void  setBetLimits(float min_bet, float max_bet, float inc) {
         _bet_sb_p->setRange(min_bet, max_bet, inc);
      }
      
   protected:
      void resizeEvent(QResizeEvent *);
};

#endif

