/***************************************************************************
                          kbubblesMain.h  -  description
                             -------------------
    begin                : Sat Nov  6 17:24:36 CET 1999
    copyright            : (C) 1999 by Tony Bjrkenius
    email                : tony.bjorkenius@linux.nu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBUBBLESMAIN_H
#define KBUBBLESMAIN_H

#include <ktmainwindow.h>

class Kbubbles;
class KbubblesConfig;

class kbubblesCreateLevel;

class KbubblesMain : public KTMainWindow
{
  Q_OBJECT 
  public:
    KbubblesMain(QWidget* parent=0, const char *name=0);
    ~KbubblesMain();
		void get_level_filename(QString *str);
		void get_hiscore_filename(QString *str);
		void get_level_path(QString *str);
		void get_kde_data_path(QString *str);
		void get_bg_img(QString *str);
	protected:
    void keyReleaseEvent(QKeyEvent *key);
  signals:
  	void restartGame();
  	void pause_game();
  	void upause_game();
  	void stopPlayingGame();
  public slots:
    void new_level(int);
    void setup_level();
    void update_points(int i);
    void start_new_game();
    void stop_game();
    void edit_levels();
    void about();
  	void highscores();
  	void config_game();
  	void done_edit_levels();
  private:
  	int check_for_highscore();
    void update_level();
    void update_lifes();
    void create_arrows();
    void show_help_label();
    QWidget *cen_win;
		KStatusBar *ksbar;
    KMenuBar *kmbar;
    KToolBar *ktbar;
    QPopupMenu *game;
    QPopupMenu *opt;
    QPopupMenu *help;
    Kbubbles *kbub;
    QLabel *help_label;
    int next_level;
    int lifes;
    int points;
    int start;
    int last_level;
		KbubblesConfig *kconf;
		kbubblesCreateLevel *kbcl;
		int usedByXSW;
};

#endif
