#ifndef _BOARD_H_
#define _BOARD_H_

#include <qwidget.h>
#include <drag.h>

#include <kchesswidget.h>

typedef enum {
    WhitePawn, WhiteKnight, WhiteBishop, WhiteRook, WhiteQueen, WhiteKing,
    BlackPawn, BlackKnight, BlackBishop, BlackRook, BlackQueen, BlackKing,
    EmptySquare 
} piece;

#define iswhite(p) ( (p >= WhitePawn) && (p <= WhiteKing))
#define isblack(p) ( (p >= BlackPawn) && (p <= BlackKing))

class Square : public KDNDWidget {

    Q_OBJECT

    // Is this a dark square ?
    bool darkSquare;
    // The piece on this square
    piece p, oldPiece;
    // Colors
    QColor light, dark, lightPiece, darkPiece;
    // Row and Column number
    uchar r, c;
    // Parent widget
    KChessWidget *parent;
    // Is the mouse pressed ?
    bool pressed;
    // Where was it pressed ?
    int press_x, press_y;
    // The string corresponding to the square
    QString s;
    // Was the piece dragged into another square ?
    bool accepted;
    
 public:
    Square(KChessWidget *, int r, int c, piece p);
    ~Square() {};
    void paintEvent(QPaintEvent *e);
    void dndMouseMoveEvent(QMouseEvent *_mouse);
    void mousePressEvent(QMouseEvent *_mouse); 
    void mouseReleaseEvent(QMouseEvent *_mouse); 
    void rootDropEvent(); 
    void dragEndEvent(); 
    void dragAccepted(); 
    QString & getBitmapName();
    const char *name() { return s;};
    void setPiece(piece _p) { p = _p; };
    piece getPiece() { return p; };

public slots:
	/**
	 * This is called whenever the user Drag n' Drops something into our
	 * window
	 */
    void slotDropEvent(KDNDDropZone *);

};

class DragPiece {
	piece p;
	Square *startSquare;
 public:
	DragPiece() { p = EmptySquare; startSquare = NULL; };
	DragPiece(piece p1, Square *_start) {
		p = p1;
		startSquare = _start;
	};
	Square *getStartSquare() { return startSquare; };
	piece getPiece() { return p; };
};

class Board {
    piece	_board[8][8];
 public:
    Board();
    ~Board();
    void clear();
    void reset();
    void set(int x, int y, piece p);
    piece get(int x, int y);

};

class KChessDNDIcon : public KDNDIcon
{
	QColor color;

 public:
/**
* Creates an Icon with the specified pixmap. _x and _y are the upper
* left corner in global coordinates.
*/
	KChessDNDIcon( QPixmap &pixmap , int _x, int _y, QColor c)
		: KDNDIcon(pixmap, _x, _y) { color = c; };
	
protected:
  virtual void paintEvent( QPaintEvent * );
};

#endif // _BOARD_H_
