/***************************************************************************
                          fun21.cpp  -  description                              
                             -------------------                                         

    version              :                                   
    begin                : Mon Mar 1 1999                                           
    copyright            : (C) 1999 by Henning Busacker                         
    email                : henning.busacker@duesseldorf.netsurf.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "fun21.h"
#include <qfont.h>
#include <qcolor.h>
#include <qtextstream.h>
#include <kmsgbox.h>
const int fun21::speedincs [5]={90,149,177,236,295};
const int fun21::multiplier [9]={50,100,150,200,250,300,400,500,1000};

fun21::fun21(QWidget *parent):Kfun21View(parent)
{
	initMetaObject();
	setName("Fun21");
	SetupGame();
	gameover=false;
	setEnabled(true);
	setFocusPolicy(QWidget::StrongFocus);
	setFocus();
}

fun21::~fun21(){
	delete deck;
	for (int i=0;i<5;i++) {
      		delete cards[i];
      		delete counts[i];
	}
   	delete totalcount;
   	delete newcard;
   	delete pl;
   	delete playground;
   	delete gridframe;
	delete dk;
	delete da;
	delete levelnames;
	delete bar;
	delete timer;
	deck=0;
}

QStrList* fun21::levelNames() {
	if (!levelnames) {
		levelnames=new QStrList();
		levelnames->append(i18n("Slow"));
		levelnames->append(i18n("Normal"));
 		levelnames->append(i18n("Fast"));
		levelnames->append(i18n("Insane"));
 		levelnames->append(i18n("Tonik"));
	}
	return levelnames;
}
void fun21::SetupGame(){
	deck = new Deck(20,10,this);
	Card::setAddFlags(DeckType, Card::disallow);
	Card::setRemoveFlags(DeckType, Card::disallow);

// preparing Colors and font for the Buttons
	QColorGroup bcg(this->backgroundColor(),this->backgroundColor(),green,
			darkGreen, this->colorGroup().mid(),yellow,this->colorGroup().base());

	QFont f("blippo",28,QFont::Bold,false);
	QFontInfo fi(f);
	if ( strcmp(f.family(),fi.family()) == 0 ) {
		// got this font
		QTextStream cout( stdout, IO_WriteOnly );
		cout << "fine! The freefont package is installed!" << endl;
	} else {
        	QTextStream cout( stdout, IO_WriteOnly );
        	cout << "Please install the freefonts package with Blippo!" << endl
			<< "It looks much nicer!" << endl;
		f.setFamily("times"); // Times should be always awailabe
		f.setPointSize(28);
		f.setBold(true);
   	}

	newcard = new QPushButton(i18n("Skip Card"),this);
	connect(newcard,SIGNAL(clicked()),SLOT(skipCard()));
	newcard->setGeometry(100,10,160,40);
	newcard->setBackgroundColor(this->backgroundColor());
	newcard->setFont(f);
	QPalette p(newcard->palette());
	p.setNormal(bcg);
	newcard->setPalette(p);
	newcard->show();

	fini = new QPushButton(i18n("Take Score!"),this);
	connect(fini,SIGNAL(clicked()),SLOT(slotTakeScore()));
	fini->setGeometry(350,10,160,40);
	fini->setBackgroundColor(this->backgroundColor());
	fini->setFont(f);
	QPalette q(fini->palette());
	q.setNormal(bcg);
	fini->setPalette(q);
	fini->show();

	totalscore = new QLabel(this,"");
	totalscore->setGeometry(180,76,250,24);
	totalscore->setAlignment(AlignCenter);
	totalscore->setFrameStyle(QFrame::Panel | QFrame::Sunken);
//	f.setPointSize(18);
//	f.setBold(false);
//	totalscore->setFont(f);
	totalscore->setText(i18n("Total Score: 0"));
	totalscore->show();
	connect(this,SIGNAL(signalTotalScore(int)),SLOT(showTotalScore(int)));

	bar = new ColorProgressBar(0,5000,5000,ColorProgressBar::Horizontal,this,"Bar");
	bar->setGeometry(130,110,340,24);
	bar->setBarStyle(ColorProgressBar::Blocked);
	bar->setLowRange(red,20);
	bar->setMidRange(yellow,50);
	bar->setHighRange(green);
	bar->setScaleFactor(0.4);
	bar->show();
	timer = new QTimer(this);
	connect(timer,SIGNAL(timeout()),SLOT(slotCountDown()));

	gridframe= new QFrame(this);
	gridframe->setMinimumSize(600,250);
	gridframe->move(10,160);
	gridframe->setBackgroundColor(this->backgroundColor());
	gridframe->show();

	dk=new Card(Card::King,Card::Clubs,this,2);
	dk->setRemoveFlags(2,Card::disallow);
	da=new Card(Card::Ace,Card::Clubs,this,2);
	dk->moveTo(520,10);
	da->moveTo(540,30);
	dk->show();
	da->show();

	playground=new QGridLayout(gridframe,3,7,0,20);
	playground->addRowSpacing(0,200);
	playground->addRowSpacing(1,20);
	playground->addRowSpacing(2,10);
	playground->addColSpacing(0,10);
	playground->addColSpacing(6,80);
   
	for (int i=0; i<5; i++) {
		cards[i]=new cardPos(0,0,gridframe,i+1);
		counts[i]=new QLabel(gridframe,"");
		playground->addWidget(cards[i],0,i+1);
		playground->addWidget(counts[i],1,i+1);
		playground->addColSpacing(i+1,60);
		counts[i]->setAlignment(AlignCenter);
		counts[i]->setFrameStyle(QFrame::Panel | QFrame::Sunken);
		counts[i]->setNum(0);
		Card::setAddFlags(i+1, Card::addSpread );
		Card::setRemoveFlags(i+1, Card::disallow);
		connect( cards[i] , SIGNAL(nonMovableCardPressed(int)),SLOT(handle(int)) );
		counts[i]->show();
		cards[i]->show();
		ascount[i]=0;
	}

	totalcount=new QLabel(gridframe,"");
	totalcount->setAlignment(AlignCenter);
	totalcount->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	totalcount->setNum(0);
	totalcount->show();
   	playground->addWidget(totalcount,1,6);

	pl=new QROListbox(gridframe);
	pl->setFont(QFont("fixed",11));
	pl->setBackgroundColor(lightGray);
	pl->insertItem(i18n("  Scoring"));
	pl->insertItem(i18n(" Multiplier"));
	pl->insertItem(" ");
	pl->insertItem(" 105   1000");
	pl->insertItem(" 104    500");
	pl->insertItem(" 103    400");
	pl->insertItem(" 102    300");
	pl->insertItem(" 101    250");
	pl->insertItem(" 100    200");
	pl->insertItem("  99    150");
	pl->insertItem("  98    100");
	pl->insertItem("  97     50");
	pl->show();

	playground->addWidget(pl,0,6);
	playground->activate();

	deck->turnTop();
}

bool fun21::handle(int pile){
        if (gameover) return false;
        pile--;
	Card* a = deck->getCard();
        a->recreate(gridframe,0,QPoint(0,0),true);
	int v=a->Value();
	int ss=0;
	ss=QString(counts[pile]->text()).toInt();
	int as=ss;
        if (v>10) v=10;
        if ((v==1) && (ss<11)){  // first ace and high Value possible
        	ascount[pile]=true;
        	v=11;
        }
        if ((v<11) && ((ss+v)>21) && ascount[pile]){ // one ace high
        	ascount[pile]=false;
        	ss=ss-10;
        }
        ss=ss+v;
        counts[pile]->setNum(ss);
        if (ss>21) { ss=21; gameover=true;}
        int t=0;
	t=QString(totalcount->text()).toInt();
        if ( t>96 ) { pl->setSelected(108-t,false);}

        t=t-as+ss;
        totalcount->setNum(t);
        if ( t>96 ) { pl->setSelected(108-t,true);}
	cards[pile]->add(a, FALSE, TRUE);
        if ((t==105) || gameover) {
		timer->stop();
                if (gameover) { // busted
		        totalcount->setNum(0);
			pl->setSelected(108-t,false);
			t=0;
			KMsgBox::message(this,i18n("Sorry"),i18n("You are busted!"),KMsgBox::EXCLAMATION);
                }
		slotTakeScore();
                return false;
        }
        else
        	deck->turnTop();
		if (!timer->isActive()) {
			slotGameRunning();
			bar->setRange(0,5000/speedincs[Speed()]*speedincs[Speed()]);
			bar->setValue(5000/speedincs[Speed()]*speedincs[Speed()]);
			timer->start(1000);
		}
        return true;
}

void fun21::slotTakeScore(){
	int score;
        timer->stop();
        int t=0;
	t=QString(totalcount->text()).toInt();
	if (t<97 && !gameover) { // not enough points
		score=0;
		KMsgBox::message(this,i18n("Sorry"),i18n("You need at least 97 points!"),KMsgBox::EXCLAMATION);
	}
        else {
		gameover=true;

		pl->setSelected(108-t,false);
        	if (t<97) score=0;
		else score=multiplier[t-97]*bar->value();
		QString a;
		QTextStream b(a,IO_WriteOnly);
		b << i18n("Current Score:") << score << endl << i18n("Points:") << bar->value()
		  << " * " << (t>96?multiplier[t-97]:0) << endl << '\0';
		KMsgBox::message(this,"Fun21",a,KMsgBox::EXCLAMATION);
	}
        clearFocus();
	slotFinished("Fun21",score);
        setFocus();
}

void fun21::skipCard() {
	away=deck->getCard();
        away->hide();
	newcard->hide();
        deck->turnTop();
}
void fun21::deal(){
        deck->hide();
	deck->collectAndShuffle();
	Card* c;
	c=deck->next();
        while (c) {
          c->recreate(deck,0,QPoint(0,0),true);
          if(c->FaceUp()) c->flipCard();
          c=c->next();
        }
	for (int i=0;i<5;i++) {
		counts[i]->setNum(0);
        }
        int t=0;
	t=QString(totalcount->text()).toInt();
        totalcount->setNum(0);
	newcard->show();
        deck->show();
        deck->turnTop();
	bar->setRange(0,5000/speedincs[Speed()]*speedincs[Speed()]);
	bar->setValue(5000/speedincs[Speed()]*speedincs[Speed()]);
        if (t>97) pl->setSelected(108-t,false);
        gameover=false;
}
void fun21::showTotalScore(int score){
	QString a;
        a.sprintf("%s: %6u",i18n("Total Score"),score);
	totalscore->setText(a);
}

void fun21::restart(){
	Kfun21View::restart();
//	QTextStream cout( stdout, IO_WriteOnly );
//	cout << "fun21.restart"<<endl;
	showTotalScore(0);
        deal();
}
void fun21::slotCountDown() {
//	QTextStream cout( stdout, IO_WriteOnly );
//	cout << "fun21.slotCountDown= " << bar->value()<<","<< speedincs[Speed()] << endl;
	if (bar->value() > speedincs[Speed()])  {
		bar->setValue(bar->value()-speedincs[Speed()]);
        } else {
        	timer->stop();
		KMsgBox::message(this,i18n("Sorry"),i18n("Timeout!"),KMsgBox::EXCLAMATION);
		slotTakeScore();
        }
}
void fun21::keyPressEvent ( QKeyEvent * e ) {
//	QTextStream cout( stdout, IO_WriteOnly );
//	cout << "fun21.keypress <" << hex << e->ascii() << "," << e->key() << "," << e->state() << ">" << endl;
	if ((e->state()==0) && (e->ascii()>0x30) && (e->ascii()<0x36)) {	
		handle(e->ascii()-0x30);
		e->accept();
	}
	if ((e->state()==0) && (e->ascii()==0x20)) {
		if (newcard->isVisible()) skipCard();
		e->accept();
	}	
	if ((e->state()==0) && (e->ascii()==0x0d)) {
		e->accept();
		slotTakeScore();
	}
}

































































