/***************************************************************************
                          kfun21view.cpp  -  description                              
                             -------------------                                         

    version              :                                   
    begin                : Son Jan 24 23:06:19 CET 1999
                                           
    copyright            : (C) 1999 by Henning Busacker                         
    email                : henning.busacker@duesseldorf.netsurf.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kfun21view.h>
#include "scoreboard.h"

Kfun21View::Kfun21View(QWidget *parent, const char *name)
	: dealer(parent, name)
{
	initMetaObject();
	totalscore=0;
	round=0;
	maxround=3;
	levelnames=0;
	speed=-1;
}

Kfun21View::~Kfun21View()
{ 
	if (deck) delete deck;
	deck = 0;
}


void Kfun21View::resizeEvent(QResizeEvent *evt)
{
	QWidget::resizeEvent(evt);

}

void Kfun21View::show()
{
	deck->show();
}

void Kfun21View::restart()
{
	totalscore=0;
	round=0;
	maxround=3;
	speed=nspeed;
        setCaption();
}

void Kfun21View::setMaxRound(short mround)
{
	maxround=mround;
}

void Kfun21View::setSpeed(int aspeed)
{
	nspeed=aspeed;
	if (speed==-1) {
		speed=aspeed;
//		setCaption();
	}
}

void Kfun21View::slotGameRunning(){
	speed=nspeed;
	round++;
	setCaption();
}

void Kfun21View::setCaption() {
	QString t;
	QTextStream ts(t,IO_WriteOnly);
	ts << name() << ": " << i18n("Hand") << " " ;
	ts << round << " - " ;
	ts << i18n("Speed") << ": " << levelnames->at(speed)<< '\0' ;
	static_cast<QWidget*>(parent())->setCaption(t);
}

void Kfun21View::slotFinished(const char* game, const int points)
{
	totalscore+=points;
	signalTotalScore(totalscore);
	if (round==maxround) {
		Scoreboard* s=new Scoreboard(0,"Scoreboard",game,levelnames,speed,totalscore);
		s->show();
		s->result();
		delete s;
		restart();
	} else {
		deal();
  	}
}


















