/* board_view.h
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#ifndef GO_BOARD_VIEW_H
#define GO_BOARD_VIEW_H

#include "go_board.h"
#include "includes.h"

/**
 * This class should implement a view on the Go-board.
 * It also implements a signal that indicates witch
 * field on the board is clicked.
 *
 * Note: the layout is quite bad at the moment, it may be
 * changed in the future. I also want to add a second view to
 * the program that uses bitmaps to show stones on the board. 
 * Any help with it is appreceated.
 * 
 * @short Show a Go board
 *
 */
class KGoBoardView : public QWidget
{
	Q_OBJECT

public:
	KGoBoardView( KGoBoard *b, QWidget *parent=0, const char *name=0 );
	
	~KGoBoardView() ;

public slots:
	void lastMove( int x, int y, int color ) ;
	void setBoard( KGoBoard* ) ;

	void legenda( bool ) ;
	bool legenda() ;

	void redraw() ;
signals:
	void positionClicked( int x, int y, int button ) ;

protected slots:
	void resizeEvent( QResizeEvent * ) ;
	void setupBoardData() ;

private:
	void paintEvent( QPaintEvent * ) ;
	void mouseReleaseEvent( QMouseEvent *mouse ) ;

	// size of board used
	inline int xBoardSize() { return xSize ; } ;
	inline int yBoardSize() { return ySize ; } ;
	// logical board size
	int xLogicalSize() ;
	int yLogicalSize() ;

	QPoint screenToLogical(int x, int y ) ;
	QPoint logicalToScreen(int x, int y ) ;
	void screenToLogicalRatios( double &x, double &y ) ;
	QPoint screenToPosition( int x, int y ) ;

	int xLogicalToPosition( int xl ) ;
	int yLogicalToPosition( int yl ) ;

	int xPositionToLogical( int xp ) ;
	int yPositionToLogical( int yp ) ;

	int logicalFieldHeight() ;
	int logicalFieldWidth() ;
	int logicalPieceSize() ;

	void drawGrid() ;
	void drawLegenda() ;
	void drawPiece( int x, int y ) ; 
	void drawZone( int x, int y ) ;
	void drawHoshi() ;
	void drawHoshiPoint( int x, int y ) ;

	KGoBoard *board ;
	int xSize, ySize ;
	QPixmap *map ;

	QPainter *painter ;
	QFont paint_font ;
	int field ;
	int border ;
	QColor line_color ;
	int lastmove_x, lastmove_y, lastmove_p ;

	bool blegenda ;
	int legenda_border ;
} ;

#endif
