/* count.cpp
 *
 * Pieter Eendebak <pte@ddsw.nl>
 */

#include "includes.h"
#include "qevent.h"
#include "count.moc"
#include "go_board.h"
#include "kgo_widget.h"
#include "go.h" 
#include "zone_board.h"

/* ##########################
 * #	class CountDialog   #
 * ##########################
 */

CountDialog::CountDialog( KGoBoard *b, QWidget *, 
			const char *name )
        : QFrame( 0 , name,
		WStyle_DialogBorder | WStyle_Title ),
		board( b )
{
	// debug("creating CountDialog") ;
	setCaption( klocale->translate("Counting scores") ) ;

	info = new QLabel( "", this ) ;
	ok = new QPushButton( "Ok", this );
        connect( ok, SIGNAL(clicked()), SLOT(nextStep()) );
	cancel = new QPushButton( "Cancel", this );
        connect( cancel, SIGNAL(clicked()), SLOT(reject()) );

	board->startCounting() ;
	zoneboard = new KZoneBoard( board, this ) ;

	progress = -1 ;
	nextStep() ;
	hide() ;
	debug("new CDialog") ;

}

CountDialog::~CountDialog()
{
	debug("delete CDialog") ;
}

void CountDialog::exec()
{
	show() ;
	return ;
}

void CountDialog::accept()
{
	hide() ;
}

void CountDialog::reject()
{
	hide() ;
}

void CountDialog::receiveInput( int x, int y, int)
{
	switch( progress )
	{
		case BEGIN:	begin() ;
				break ;
		case REMOVE_DEAD_PIECES:
				zoneboard->removeDead( x, y ) ;
				break ;
		case ALLOCATE_ZONES:
		case COUNT_TOTAL:
				break ;
		case DONE:	break ;
		default:	// show some error
				break ;
	}
	resize() ;
}

void CountDialog::begin()
{
	QString tmp = klocale->translate(
		"The computer cannot count scores itself, so\n"
		"we'll need some help. We will calculate the scores\n"
		"in 3 steps:\n\n"
		"- Remove dead pieces\n"
		"- Allocate zones\n"
		"- Calculate the total scores\n"
		"\n\n"
		"At each step you can press the Ok button to go on."
			) ;

	info->setText( tmp.data() ) ;
}

void CountDialog::removeDeadPieces()
{
	QString tmp = klocale->translate(
		"You can now remove the dead pieces by clicking\n"
		"with the mouse.\n\n"
			) ;

	info->setText( tmp.data() ) ;
}

void CountDialog::allocateZones()
{
	zoneboard->determineZones() ;

	QString tmp = klocale->translate(
		"The zones have been allocated automatically\n"
		"for you.\n"
			) ;
	info->setText( tmp.data() ) ;
}

void CountDialog::countTotal()
{
	int w = board->getWhiteScore() ;
	int b = board->getBlackScore() ;

	QString tmp = "" ;
	tmp.sprintf(
		"The total scores are:\n\n"
		"White:	%4d\n"
		"Black: %4d\n"
		"\n",
		w, b ) ;
	info->setText( tmp.data() ) ;
}

void CountDialog::nextStep()
{
	// printf("nextStep() - step %d\n", progress ) ;

	switch( ++progress )
	{
		case BEGIN:	begin() ;
				break ;
		case REMOVE_DEAD_PIECES:
				removeDeadPieces() ;
				break ;
		case ALLOCATE_ZONES:
				allocateZones() ;
				break ;
		case COUNT_TOTAL:
				countTotal() ;
				break ;
		case DONE:	end() ;
				break ;
		default:	KGoWidget::error("count.cpp") ;
				break ;
	}
	resize() ;
}

void CountDialog::end()
{
	delete zoneboard ;
	accept() ;
	emit countingReady() ;
}


#define MAX(x,y) ((x>y)?x:y) 

void CountDialog::resize( int x, int y )
{
	QFrame::resize( x, y ) ;
}

void CountDialog::resize()
{
	QSize s, t ;
	const int border = 5 ; 
	int x=0, y=0 ;
	int xm=100 ;

	x += border ; y += border ;

	s = info->sizeHint() ; 
	info->setGeometry( border, border,
		s.width(), s.height() ) ;
	xm = MAX(xm,s.width()) ; y+=s.height() ;

	y+=border ;

	s = ok->sizeHint() ;
	t = cancel->sizeHint() ;

	ok->setGeometry( x, y, 
		s.width(), s.height() ) ;
	cancel->setGeometry( x + s.width() + border, y, 
		t.width(), t.height() ) ;
	y+=s.height() ;

	x += xm ;
	x += border ; y += border ;

	resize( x, y ) ; 
}

int CountDialog::getProgress()
{
	return progress ;
}


